/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.logger;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.logger.LogLevel;
import de.quantummaid.httpmaid.logger.LogMessage;
import de.quantummaid.httpmaid.logger.LoggerImplementation;
import de.quantummaid.httpmaid.util.Validators;

public final class Logger {
    private final LoggerImplementation loggerImplementation;
    private final MetaData metaData;

    public static Logger logger(LoggerImplementation loggerImplementation, MetaData metaData) {
        Validators.validateNotNull(loggerImplementation, "loggerImplementation");
        Validators.validateNotNull(metaData, "metaData");
        return new Logger(loggerImplementation, metaData);
    }

    public void trace(String message) {
        this.log(message, LogLevel.TRACE);
    }

    public void trace(Throwable throwable) {
        this.log(throwable, LogLevel.TRACE);
    }

    public void trace(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.TRACE);
    }

    public void debug(String message) {
        this.log(message, LogLevel.DEBUG);
    }

    public void debug(Throwable throwable) {
        this.log(throwable, LogLevel.DEBUG);
    }

    public void debug(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.DEBUG);
    }

    public void info(String message) {
        this.log(message, LogLevel.INFO);
    }

    public void info(Throwable throwable) {
        this.log(throwable, LogLevel.INFO);
    }

    public void info(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.INFO);
    }

    public void warn(String message) {
        this.log(message, LogLevel.WARN);
    }

    public void warn(Throwable throwable) {
        this.log(throwable, LogLevel.WARN);
    }

    public void warn(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.WARN);
    }

    public void error(String message) {
        this.log(message, LogLevel.ERROR);
    }

    public void error(Throwable throwable) {
        this.log(throwable, LogLevel.ERROR);
    }

    public void error(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.ERROR);
    }

    public void fatal(String message) {
        this.log(message, LogLevel.FATAL);
    }

    public void fatal(Throwable throwable) {
        this.log(throwable, LogLevel.FATAL);
    }

    public void fatal(Throwable throwable, String message) {
        this.log(throwable, message, LogLevel.FATAL);
    }

    public void log(String message, LogLevel logLevel) {
        this.log(null, message, logLevel);
    }

    public void log(Throwable throwable, LogLevel logLevel) {
        this.log(throwable, null, logLevel);
    }

    public void log(Throwable throwable, String message, LogLevel logLevel) {
        LogMessage logMessage = LogMessage.logMessage(message, throwable, logLevel, this.metaData);
        this.loggerImplementation.log(logMessage);
    }

    public String toString() {
        return "Logger(loggerImplementation=" + this.loggerImplementation + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logger)) {
            return false;
        }
        Logger other = (Logger)o;
        LoggerImplementation this$loggerImplementation = this.loggerImplementation;
        LoggerImplementation other$loggerImplementation = other.loggerImplementation;
        if (this$loggerImplementation == null ? other$loggerImplementation != null : !this$loggerImplementation.equals(other$loggerImplementation)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoggerImplementation $loggerImplementation = this.loggerImplementation;
        result = result * 59 + ($loggerImplementation == null ? 43 : $loggerImplementation.hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    private Logger(LoggerImplementation loggerImplementation, MetaData metaData) {
        this.loggerImplementation = loggerImplementation;
        this.metaData = metaData;
    }
}

