/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.MarshallingException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collection;
import java.util.stream.Collectors;

public final class UnsupportedContentTypeException
extends MarshallingException {
    private UnsupportedContentTypeException(String message) {
        super(message);
    }

    static UnsupportedContentTypeException unsupportedContentTypeException(ContentType contentType, Collection<ContentType> supportedContentTypes) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(supportedContentTypes, "supportedContentTypes");
        String supported = supportedContentTypes.stream().map(ContentType::internalValueForMapping).collect(Collectors.joining(", ", "'", "'"));
        return new UnsupportedContentTypeException(String.format("Content type '%s' is not supported; supported content types are: %s", contentType.internalValueForMapping(), supported));
    }
}

