/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.urlencoded;

import de.quantummaid.httpmaid.util.Validators;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KeyElement {
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("[0-9]+");
    private final String value;

    static KeyElement keyElement(String value) {
        Validators.validateNotNull(value, "value");
        return new KeyElement(value);
    }

    boolean isArrayIndex() {
        Matcher matcher = ARRAY_INDEX_PATTERN.matcher(this.value);
        return matcher.matches();
    }

    int asArrayIndex() {
        return Integer.parseInt(this.value);
    }

    String value() {
        return this.value;
    }

    String renderAsFirstElement() {
        return URLDecoder.decode(this.value, StandardCharsets.UTF_8);
    }

    String renderAsIndexElement() {
        return String.format("[%s]", this.renderAsFirstElement());
    }

    public String toString() {
        return "KeyElement(value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyElement)) {
            return false;
        }
        KeyElement other = (KeyElement)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private KeyElement(String value) {
        this.value = value;
    }
}

