/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.urlencoded;

import de.quantummaid.httpmaid.marshalling.urlencoded.Key;
import de.quantummaid.httpmaid.marshalling.urlencoded.KeyElement;
import de.quantummaid.httpmaid.marshalling.urlencoded.KeyValue;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class ParsedUrlEncoded {
    private final List<KeyValue> keyValues;

    static ParsedUrlEncoded parse(String string) {
        Validators.validateNotNull(string, "string");
        List<KeyValue> keyValues = Arrays.stream(string.split("&")).map(KeyValue::parse).collect(Collectors.toList());
        return new ParsedUrlEncoded(keyValues);
    }

    List<KeyElement> directChildren(Key prefix) {
        return this.keyValues.stream().map(KeyValue::key).filter(prefix::isPrefixTo).map(key -> key.elementAfter(prefix)).collect(Collectors.toList());
    }

    Optional<String> getValue(Key key) {
        return this.keyValues.stream().filter(keyValue -> keyValue.key().equals(key)).map(KeyValue::value).findFirst();
    }

    public String toString() {
        return "ParsedUrlEncoded(keyValues=" + this.keyValues + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParsedUrlEncoded)) {
            return false;
        }
        ParsedUrlEncoded other = (ParsedUrlEncoded)o;
        List<KeyValue> this$keyValues = this.keyValues;
        List<KeyValue> other$keyValues = other.keyValues;
        return !(this$keyValues == null ? other$keyValues != null : !((Object)this$keyValues).equals(other$keyValues));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KeyValue> $keyValues = this.keyValues;
        result = result * 59 + ($keyValues == null ? 43 : ((Object)$keyValues).hashCode());
        return result;
    }

    private ParsedUrlEncoded(List<KeyValue> keyValues) {
        this.keyValues = keyValues;
    }
}

