/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Streams;

public final class StringBodyToStreamProcessor
implements Processor {
    public static Processor stringBodyToStreamProcessor() {
        return new StringBodyToStreamProcessor();
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.RESPONSE_CONTENT_TYPE).ifPresent(contentType -> metaData.getOptional(HttpMaidChainKeys.RESPONSE_HEADERS).ifPresent(headers -> headers.put("Content-Type", contentType.internalValueForMapping())));
        if (!metaData.contains(HttpMaidChainKeys.RESPONSE_STREAM)) {
            metaData.getOptional(HttpMaidChainKeys.RESPONSE_BODY_STRING).ifPresent(stringResponse -> metaData.set(HttpMaidChainKeys.RESPONSE_STREAM, Streams.stringToInputStream(stringResponse)));
        }
    }

    public String toString() {
        return "StringBodyToStreamProcessor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof StringBodyToStreamProcessor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private StringBodyToStreamProcessor() {
    }
}

