/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

import de.quantummaid.httpmaid.util.describing.CardBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MapDumper {
    private MapDumper() {
    }

    public static String describe(String title, Map<String, Object> map) {
        CardBuilder cardBuilder = CardBuilder.cardBuilder();
        cardBuilder.setHeadline(title);
        map.forEach((key, value) -> {
            String valueAsString = MapDumper.valueToString(value);
            cardBuilder.addEntry((String)key, valueAsString);
        });
        return cardBuilder.build();
    }

    private static String valueToString(Object value) {
        if (Objects.isNull(value)) {
            return "null";
        }
        if (!(value instanceof Map)) {
            return value.toString();
        }
        Map map = (Map)value;
        return map.entrySet().stream().map(entry -> entry.getKey().toString() + " = " + entry.getValue().toString()).collect(Collectors.joining("\n"));
    }
}

