/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.cors.domain.Origin;
import de.quantummaid.httpmaid.cors.domain.RequestedHeaders;
import de.quantummaid.httpmaid.cors.domain.RequestedMethod;
import de.quantummaid.httpmaid.cors.policy.ResourceSharingPolicy;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.Map;

public final class PreflightRequestProcessor
implements Processor {
    private final ResourceSharingPolicy resourceSharingPolicy;

    public static Processor preflightRequestProcessor(ResourceSharingPolicy resourceSharingPolicy) {
        Validators.validateNotNull(resourceSharingPolicy, "resourceSharingPolicy");
        return new PreflightRequestProcessor(resourceSharingPolicy);
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.set(HttpMaidChainKeys.RESPONSE_HEADERS, new HashMap());
        metaData.set(HttpMaidChainKeys.RESPONSE_STATUS, 200);
        Origin.load(metaData).ifPresent(origin -> {
            if (!this.resourceSharingPolicy.validateOrigin((Origin)origin)) {
                return;
            }
            RequestedMethod requestedMethod = RequestedMethod.load(metaData);
            RequestedHeaders requestedHeaders = RequestedHeaders.load(metaData);
            if (!this.resourceSharingPolicy.validateRequestedMethod(requestedMethod)) {
                return;
            }
            if (!this.resourceSharingPolicy.validateRequestedHeaders(requestedHeaders)) {
                return;
            }
            Map<String, String> responseHeaders = metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS);
            responseHeaders.put("Access-Control-Allow-Origin", origin.internalValueForMapping());
            if (this.resourceSharingPolicy.supportsCredentials()) {
                responseHeaders.put("Access-Control-Allow-Credentials", "true");
            }
            this.resourceSharingPolicy.maxAge().generateHeaderValue().ifPresent(maxAge -> responseHeaders.put("Access-Control-Max-Age", (String)maxAge));
            if (!requestedMethod.isSimpleMethod()) {
                responseHeaders.put("Access-Control-Allow-Methods", requestedMethod.internalValueForMapping());
            }
            requestedHeaders.generateHeaderValue().ifPresent(allowedHeaders -> responseHeaders.put("Access-Control-Allow-Headers", (String)allowedHeaders));
        });
    }

    public String toString() {
        return "PreflightRequestProcessor(resourceSharingPolicy=" + this.resourceSharingPolicy + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreflightRequestProcessor)) {
            return false;
        }
        PreflightRequestProcessor other = (PreflightRequestProcessor)o;
        ResourceSharingPolicy this$resourceSharingPolicy = this.resourceSharingPolicy;
        ResourceSharingPolicy other$resourceSharingPolicy = other.resourceSharingPolicy;
        return !(this$resourceSharingPolicy == null ? other$resourceSharingPolicy != null : !((Object)this$resourceSharingPolicy).equals(other$resourceSharingPolicy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceSharingPolicy $resourceSharingPolicy = this.resourceSharingPolicy;
        result = result * 59 + ($resourceSharingPolicy == null ? 43 : ((Object)$resourceSharingPolicy).hashCode());
        return result;
    }

    private PreflightRequestProcessor(ResourceSharingPolicy resourceSharingPolicy) {
        this.resourceSharingPolicy = resourceSharingPolicy;
    }
}

