/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.http.PathParameters;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.cookies.Cookies;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.util.Validators;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

public final class HttpRequest {
    private final MetaData metaData;

    public static HttpRequest httpRequest(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        return new HttpRequest(metaData);
    }

    public HttpRequestMethod method() {
        return this.metaData.get(HttpMaidChainKeys.METHOD);
    }

    public Path path() {
        return this.metaData.get(HttpMaidChainKeys.PATH);
    }

    public PathParameters pathParameters() {
        return this.metaData.get(HttpMaidChainKeys.PATH_PARAMETERS);
    }

    public QueryParameters queryParameters() {
        return this.metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS);
    }

    public Headers headers() {
        return this.metaData.get(HttpMaidChainKeys.REQUEST_HEADERS);
    }

    public Cookies cookies() {
        return Cookies.cookiesFromHeaders(this.headers());
    }

    public Optional<String> optionalBodyString() {
        return this.metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_STRING);
    }

    public String bodyString() {
        return this.optionalBodyString().orElseThrow(() -> new RuntimeException("Request does not have a body"));
    }

    public InputStream bodyStream() {
        return this.metaData.get(HttpMaidChainKeys.REQUEST_BODY_STREAM);
    }

    public Optional<Object> authenticationInformation() {
        return this.metaData.getOptional(HttpMaidChainKeys.AUTHENTICATION_INFORMATION);
    }

    public <T> Optional<T> authenticationInformationAs(Class<T> type) {
        Validators.validateNotNull(type, "type");
        return this.authenticationInformation();
    }

    public Map<String, Object> bodyMap() {
        return this.optionalBodyMap().orElseThrow(() -> new RuntimeException("Request does not have a body map"));
    }

    public Optional<Map<String, Object>> optionalBodyMap() {
        return this.metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_MAP);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return "HttpRequest(metaData=" + this.getMetaData() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        MetaData this$metaData = this.getMetaData();
        MetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    private HttpRequest(MetaData metaData) {
        this.metaData = metaData;
    }
}

