/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.path.statemachine.StateMachineMatcher;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CaptureMatcher
implements StateMachineMatcher<String> {
    private static final Pattern PATTERN = Pattern.compile("<(.*)>");
    private final String name;

    static boolean isWildcard(String stringSpecification) {
        Matcher matcher = PATTERN.matcher(stringSpecification);
        return matcher.matches();
    }

    static StateMachineMatcher<String> fromStringSpecification(String stringSpecification) {
        Validators.validateNotNullNorEmpty(stringSpecification, "stringSpecification");
        Matcher matcher = PATTERN.matcher(stringSpecification);
        if (!matcher.matches()) {
            throw new RuntimeException("Not a wildcard: " + stringSpecification);
        }
        String name = matcher.group(1);
        return new CaptureMatcher(name);
    }

    @Override
    public Optional<Map<String, String>> matchAndReturnCaptures(String element) {
        return Optional.of(Map.of(this.name, element));
    }

    public String toString() {
        return "CaptureMatcher(name=" + this.name + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptureMatcher)) {
            return false;
        }
        CaptureMatcher other = (CaptureMatcher)o;
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    private CaptureMatcher(String name) {
        this.name = name;
    }
}

