/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.path.PathResolver;
import de.quantummaid.httpmaid.path.PathTemplate;
import de.quantummaid.httpmaid.util.Validators;

public class Path {
    private final String path;

    public static Path path(String path) {
        Validators.validateNotNull(path, "path");
        return new Path(path);
    }

    public boolean matches(String template) {
        PathTemplate pathTemplate = PathTemplate.pathTemplate(template);
        return pathTemplate.matches(this);
    }

    public Path cutPrefix(String prefix) {
        Validators.validateNotNull(prefix, "prefix");
        if (!this.path.startsWith(prefix)) {
            throw new IllegalArgumentException(String.format("Path '%s' does not start with '%s'", this.path, prefix));
        }
        String cutPath = this.path.substring(prefix.length());
        return new Path(cutPath);
    }

    public Path safelyRebaseTo(String prefix) {
        String rebasedPath = PathResolver.resolvePath(prefix, this.path);
        return Path.path(rebasedPath);
    }

    public String raw() {
        return this.path;
    }

    public String toString() {
        return "Path(path=" + this.path + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Path;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    private Path(String path) {
        this.path = path;
    }
}

