/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.purejavaendpoint;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.purejavaendpoint.PortStage;
import de.quantummaid.httpmaid.purejavaendpoint.PureJavaEndpointHandler;
import java.io.IOException;
import java.net.InetSocketAddress;

public final class PureJavaEndpoint
implements AutoCloseable {
    private final HttpServer httpServer;

    public static PortStage pureJavaEndpointFor(HttpMaid httpMaid) {
        return port -> {
            HttpServer httpServer;
            try {
                httpServer = HttpServer.create(new InetSocketAddress(port), 0);
                HttpHandler httpHandler = PureJavaEndpointHandler.javaOnlyEndpointHandler(httpMaid);
                httpServer.createContext("/", httpHandler);
                httpServer.setExecutor(null);
                httpServer.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new PureJavaEndpoint(httpServer);
        };
    }

    @Override
    public void close() {
        this.httpServer.stop(0);
    }

    private PureJavaEndpoint(HttpServer httpServer) {
        this.httpServer = httpServer;
    }
}

