/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.criteria;

import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.websockets.criteria.HeaderCriterion;
import de.quantummaid.httpmaid.websockets.criteria.QueryParameterCriterion;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class WebsocketCriteria {
    private final List<HeaderCriterion> headerCriteria;
    private final List<QueryParameterCriterion> queryParameterCriteria;

    public static WebsocketCriteria websocketCriteria() {
        return new WebsocketCriteria(new ArrayList<HeaderCriterion>(), new ArrayList<QueryParameterCriterion>());
    }

    public WebsocketCriteria header(String name, String value) {
        HeaderCriterion headerCriterion = HeaderCriterion.headerCriterion(HeaderName.headerName(name), HeaderValue.headerValue(value));
        this.headerCriteria.add(headerCriterion);
        return this;
    }

    public WebsocketCriteria queryParameter(String name, String value) {
        QueryParameterCriterion queryParameterCriterion = QueryParameterCriterion.queryParameterCriterion(QueryParameterName.queryParameterName(name), QueryParameterValue.queryParameterValue(value));
        this.queryParameterCriteria.add(queryParameterCriterion);
        return this;
    }

    public boolean filter(WebsocketRegistryEntry entry) {
        boolean headersAreMatched = this.headerCriteria.stream().allMatch(headerCriterion -> headerCriterion.filter(entry));
        boolean queryParametersAreMatched = this.queryParameterCriteria.stream().allMatch(queryParameterCriterion -> queryParameterCriterion.filter(entry));
        return headersAreMatched && queryParametersAreMatched;
    }

    @Generated
    private WebsocketCriteria(List<HeaderCriterion> headerCriteria, List<QueryParameterCriterion> queryParameterCriteria) {
        this.headerCriteria = headerCriteria;
        this.queryParameterCriteria = queryParameterCriteria;
    }
}

