/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.Chain;
import de.quantummaid.httpmaid.chains.ChainException;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.GraphCreator;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.chains.ModuleIdentifier;
import de.quantummaid.httpmaid.chains.NoChainForNameException;
import de.quantummaid.httpmaid.chains.ProcessingContext;
import de.quantummaid.httpmaid.chains.RegisteredProcessor;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.chains.rules.Rule;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;

public class ChainRegistry {
    public static final MetaDataKey<ChainRegistry> CHAIN_REGISTRY = MetaDataKey.metaDataKey("CHAIN_REGISTRY");
    private final Map<ChainName, Chain> namedChains;
    private final MetaData metaData;

    static ChainRegistry emptyChainRegistry(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        ChainRegistry chainRegistry = new ChainRegistry(new HashMap<ChainName, Chain>(), metaData);
        chainRegistry.metaData.set(CHAIN_REGISTRY, chainRegistry);
        return chainRegistry;
    }

    void extend(ChainModule module) {
        Validators.validateNotNull(module, "module");
        ModuleIdentifier identifier = module.identifier();
        ChainExtender extender = ChainExtender.chainExtender(this, identifier, this.metaData);
        module.register(extender);
    }

    public void putIntoChain(ChainName chainName, MetaData initialMetaData, Consumer<MetaData> consumer) {
        ProcessingContext processingContext = ProcessingContext.processingContext(initialMetaData, consumer);
        this.accept(chainName, processingContext);
    }

    private void accept(ChainName chainName, ProcessingContext processingContext) {
        Chain chain = this.getChainFor(chainName);
        Action action = chain.accept(processingContext);
        this.handleAction(action, processingContext);
    }

    private void handleAction(Action action, ProcessingContext processingContext) {
        if (action instanceof Jump) {
            Jump jump = (Jump)action;
            ChainName name = jump.target().orElseThrow();
            this.accept(name, processingContext);
        } else if (action instanceof Consume) {
            processingContext.consume();
        } else if (!(action instanceof Drop)) {
            throw ChainException.chainException("Unknown action: " + action.getClass().getName());
        }
    }

    public String dump() {
        return GraphCreator.createGraph(this.namedChains).plot();
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.metaData.get(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.metaData.getOptional(key);
    }

    public <T> void addMetaDatum(MetaDataKey<T> key, T value) {
        Validators.validateNotNull(key, "key");
        Validators.validateNotNull(value, "value");
        this.metaData.set(key, value);
    }

    void createChain(ChainName name, Action defaultAction, Action exceptionAction, ModuleIdentifier moduleIdentifier) {
        Validators.validateNotNull(name, "name");
        Validators.validateNotNull(defaultAction, "defaultAction");
        Validators.validateNotNull(exceptionAction, "exceptionAction");
        Validators.validateNotNull(moduleIdentifier, "moduleIdentifier");
        if (this.namedChains.containsKey(name)) {
            throw ChainException.chainException(String.format("A chain with name '%s' already exists", name.name()));
        }
        Chain chain = Chain.chain(defaultAction, exceptionAction, name, moduleIdentifier);
        this.namedChains.put(name, chain);
    }

    void prependProcessorToChain(ChainName chainName, RegisteredProcessor processor) {
        Validators.validateNotNull(chainName, "chainName");
        Validators.validateNotNull(processor, "processor");
        Chain chain = this.getChainFor(chainName);
        chain.prependProcessor(processor);
    }

    void appendProcessorToChain(ChainName chainName, RegisteredProcessor processor) {
        Validators.validateNotNull(chainName, "chainName");
        Validators.validateNotNull(processor, "processor");
        Chain chain = this.getChainFor(chainName);
        chain.appendProcessor(processor);
    }

    void addRoutingRouleToChain(ChainName chainName, Rule rule) {
        Validators.validateNotNull(chainName, "chainName");
        Validators.validateNotNull(rule, "rule");
        Chain chain = this.getChainFor(chainName);
        chain.addRoutingRule(rule);
    }

    private Chain getChainFor(ChainName chainName) {
        Validators.validateNotNull(chainName, "chainName");
        if (this.namedChains.containsKey(chainName)) {
            return this.namedChains.get(chainName);
        }
        throw new NoChainForNameException(chainName);
    }

    @Generated
    private ChainRegistry(Map<ChainName, Chain> namedChains, MetaData metaData) {
        this.namedChains = namedChains;
        this.metaData = metaData;
    }
}

