/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.Marshallers;
import de.quantummaid.httpmaid.marshalling.MarshallingException;
import java.util.function.Supplier;
import lombok.Generated;

public final class MarshalProcessor
implements Processor {
    private final Marshallers marshallers;
    private final boolean throwExceptionIfNoMarshallerFound;

    public static MarshalProcessor marshalProcessor(Marshallers marshallers, boolean throwExceptionIfNoMarshallerFound) {
        return new MarshalProcessor(marshallers, throwExceptionIfNoMarshallerFound);
    }

    @Override
    public void apply(MetaData metaData) {
        block2: {
            try {
                metaData.getOptional(HttpMaidChainKeys.RESPONSE_BODY_OBJECT).ifPresent(map -> {
                    ContentType responseContentType = this.marshallers.determineResponseContentType(metaData);
                    Marshaller marshaller = this.marshallers.marshallerFor(responseContentType);
                    metaData.set(HttpMaidChainKeys.RESPONSE_CONTENT_TYPE, responseContentType);
                    String stringBody = marshaller.marshall(map);
                    metaData.set(HttpMaidChainKeys.RESPONSE_BODY_STRING, stringBody);
                });
            }
            catch (MarshallingException e) {
                if (!metaData.getOptional(HttpMaidChainKeys.EXCEPTION).isEmpty()) break block2;
                this.failIfConfiguredToDoSo(() -> MarshallingException.marshallingException(e));
            }
        }
    }

    private void failIfConfiguredToDoSo(Supplier<RuntimeException> exceptionSupplier) {
        if (this.throwExceptionIfNoMarshallerFound) {
            throw exceptionSupplier.get();
        }
    }

    @Generated
    public String toString() {
        return "MarshalProcessor(marshallers=" + this.marshallers + ", throwExceptionIfNoMarshallerFound=" + this.throwExceptionIfNoMarshallerFound + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshalProcessor)) {
            return false;
        }
        MarshalProcessor other = (MarshalProcessor)o;
        if (this.throwExceptionIfNoMarshallerFound != other.throwExceptionIfNoMarshallerFound) {
            return false;
        }
        Marshallers this$marshallers = this.marshallers;
        Marshallers other$marshallers = other.marshallers;
        return !(this$marshallers == null ? other$marshallers != null : !((Object)this$marshallers).equals(other$marshallers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.throwExceptionIfNoMarshallerFound ? 79 : 97);
        Marshallers $marshallers = this.marshallers;
        result = result * 59 + ($marshallers == null ? 43 : ((Object)$marshallers).hashCode());
        return result;
    }

    @Generated
    private MarshalProcessor(Marshallers marshallers, boolean throwExceptionIfNoMarshallerFound) {
        this.marshallers = marshallers;
        this.throwExceptionIfNoMarshallerFound = throwExceptionIfNoMarshallerFound;
    }
}

