/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import lombok.Generated;

public final class RawWebsocketConnect
implements RawRequest {
    private final ConnectionInformation connectionInformation;
    private final WebsocketSenderId websocketSenderId;
    private final QueryParameters queryParameters;
    private final Headers headers;

    public static RawWebsocketConnectBuilder rawWebsocketConnectBuilder() {
        return RawWebsocketConnectBuilder.rawWebsocketConnectBuilder();
    }

    public static RawWebsocketConnect rawWebsocketConnect(ConnectionInformation connectionInformation, WebsocketSenderId websocketSenderId, QueryParameters queryParameters, Headers headers) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(websocketSenderId, "websocketSenderId");
        Validators.validateNotNull(queryParameters, "queryParameters");
        Validators.validateNotNull(headers, "headers");
        return new RawWebsocketConnect(connectionInformation, websocketSenderId, queryParameters, headers);
    }

    @Override
    public void enter(MetaData metaData) {
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION, this.connectionInformation);
        metaData.set(WebsocketSenderId.WEBSOCKET_SENDER_ID, this.websocketSenderId);
        metaData.set(WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_CONNECT");
        metaData.set(HttpMaidChainKeys.QUERY_PARAMETERS, this.queryParameters);
        metaData.set(HttpMaidChainKeys.REQUEST_HEADERS, this.headers);
    }

    @Generated
    public String toString() {
        return "RawWebsocketConnect(connectionInformation=" + this.connectionInformation + ", websocketSenderId=" + this.websocketSenderId + ", queryParameters=" + this.queryParameters + ", headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketConnect)) {
            return false;
        }
        RawWebsocketConnect other = (RawWebsocketConnect)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$websocketSenderId = this.websocketSenderId;
        WebsocketSenderId other$websocketSenderId = other.websocketSenderId;
        if (this$websocketSenderId == null ? other$websocketSenderId != null : !((Object)this$websocketSenderId).equals(other$websocketSenderId)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $websocketSenderId = this.websocketSenderId;
        result = result * 59 + ($websocketSenderId == null ? 43 : ((Object)$websocketSenderId).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketConnect(ConnectionInformation connectionInformation, WebsocketSenderId websocketSenderId, QueryParameters queryParameters, Headers headers) {
        this.connectionInformation = connectionInformation;
        this.websocketSenderId = websocketSenderId;
        this.queryParameters = queryParameters;
        this.headers = headers;
    }
}

