/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import lombok.Generated;

public final class RawWebsocketMessage
implements RawRequest {
    private final ConnectionInformation connectionInformation;
    private final String body;

    public static RawWebsocketMessage rawWebsocketMessage(ConnectionInformation connectionInformation, String body) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(body, "body");
        return new RawWebsocketMessage(connectionInformation, body);
    }

    @Override
    public void enter(MetaData metaData) {
        metaData.set(WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_MESSAGE");
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, false);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION, this.connectionInformation);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STRING, this.body);
    }

    @Generated
    public String toString() {
        return "RawWebsocketMessage(connectionInformation=" + this.connectionInformation + ", body=" + this.body + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketMessage)) {
            return false;
        }
        RawWebsocketMessage other = (RawWebsocketMessage)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        String this$body = this.body;
        String other$body = other.body;
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        String $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @Generated
    private RawWebsocketMessage(ConnectionInformation connectionInformation, String body) {
        this.connectionInformation = connectionInformation;
        this.body = body;
    }
}

