/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.criteria;

import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.List;
import lombok.Generated;

public final class HeaderCriterion {
    private final HeaderName name;
    private final HeaderValue value;

    public static HeaderCriterion headerCriterion(HeaderName name, HeaderValue value) {
        return new HeaderCriterion(name, value);
    }

    public boolean filter(WebsocketRegistryEntry entry) {
        List<String> values = entry.headers().allValuesFor(this.name.stringValue());
        return values.contains(this.value.stringValue());
    }

    public HeaderName name() {
        return this.name;
    }

    public HeaderValue value() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "HeaderCriterion(name=" + this.name + ", value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderCriterion)) {
            return false;
        }
        HeaderCriterion other = (HeaderCriterion)o;
        HeaderName this$name = this.name;
        HeaderName other$name = other.name;
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        HeaderValue this$value = this.value;
        HeaderValue other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HeaderName $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        HeaderValue $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    private HeaderCriterion(HeaderName name, HeaderValue value) {
        this.name = name;
        this.value = value;
    }
}

