/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import lombok.Generated;

public final class RestoreWebsocketContextInformationProcessor
implements Processor {
    public static Processor restoreWebsocketContextInformationProcessor() {
        return new RestoreWebsocketContextInformationProcessor();
    }

    @Override
    public void apply(MetaData metaData) {
        boolean isWebsocketMessage = metaData.getOptional(WebsocketMetaDataKeys.REQUEST_TYPE).map("WEBSOCKET_MESSAGE"::equals).orElse(false);
        if (isWebsocketMessage) {
            WebsocketRegistry websocketRegistry = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
            ConnectionInformation connectionInformation = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION);
            if (metaData.getOptional(WebsocketMetaDataKeys.RESTORATION_FROM_REGISTRY_NEEDED).orElse(true).booleanValue()) {
                WebsocketRegistryEntry entry = websocketRegistry.byConnectionInformation(connectionInformation);
                entry.restoreToMetaData(metaData);
            }
        }
    }

    @Generated
    public String toString() {
        return "RestoreWebsocketContextInformationProcessor()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof RestoreWebsocketContextInformationProcessor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private RestoreWebsocketContextInformationProcessor() {
    }
}

