/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.processors.AddWebsocketsMetaDataProcessor;
import de.quantummaid.httpmaid.websockets.processors.DetermineWebsocketRouteProcessor;
import de.quantummaid.httpmaid.websockets.processors.PutWebsocketInRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RemoveWebsocketFromRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RestoreWebsocketContextInformationProcessor;
import de.quantummaid.httpmaid.websockets.registry.InMemoryRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import lombok.Generated;

public final class WebsocketsModule
implements ChainModule {
    private static final ChainName CONNECT_WEBSOCKET = ChainName.chainName("CONNECT_WEBSOCKET");
    private static final ChainName DISCONNECT_WEBSOCKET = ChainName.chainName("DISCONNECT_WEBSOCKET");
    private String routeSelectionExpression = "message";
    private WebsocketRegistry websocketRegistry = InMemoryRegistry.inMemoryRegistry();

    public static WebsocketsModule websocketsModule() {
        return new WebsocketsModule();
    }

    public void setRouteSelectionExpression(String routeSelectionExpression) {
        this.routeSelectionExpression = routeSelectionExpression;
    }

    public void setWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        this.websocketRegistry = websocketRegistry;
    }

    @Override
    public void register(ChainExtender extender) {
        extender.addMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY, this.websocketRegistry);
        WebsocketSenders websocketSenders = extender.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        extender.appendProcessor(HttpMaidChains.INIT, AddWebsocketsMetaDataProcessor.addWebsocketRegistryProcessor(websocketSenders, this.websocketRegistry));
        extender.appendProcessor(HttpMaidChains.PRE_PROCESS, RestoreWebsocketContextInformationProcessor.restoreWebsocketContextInformationProcessor());
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(CONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_CONNECT");
        extender.createChain(CONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(CONNECT_WEBSOCKET, PutWebsocketInRegistryProcessor.putWebsocketInRegistryProcessor());
        extender.appendProcessor(HttpMaidChains.PRE_DETERMINE_HANDLER, DetermineWebsocketRouteProcessor.determineWebsocketRouteProcessor(this.routeSelectionExpression));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(DISCONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_DISCONNECT");
        extender.createChain(DISCONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(DISCONNECT_WEBSOCKET, RemoveWebsocketFromRegistryProcessor.removeWebsocketFromRegistryProcessor());
    }

    @Generated
    public String toString() {
        return "WebsocketsModule(routeSelectionExpression=" + this.routeSelectionExpression + ", websocketRegistry=" + this.websocketRegistry + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketsModule)) {
            return false;
        }
        WebsocketsModule other = (WebsocketsModule)o;
        String this$routeSelectionExpression = this.routeSelectionExpression;
        String other$routeSelectionExpression = other.routeSelectionExpression;
        if (this$routeSelectionExpression == null ? other$routeSelectionExpression != null : !this$routeSelectionExpression.equals(other$routeSelectionExpression)) {
            return false;
        }
        WebsocketRegistry this$websocketRegistry = this.websocketRegistry;
        WebsocketRegistry other$websocketRegistry = other.websocketRegistry;
        return !(this$websocketRegistry == null ? other$websocketRegistry != null : !this$websocketRegistry.equals(other$websocketRegistry));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routeSelectionExpression = this.routeSelectionExpression;
        result = result * 59 + ($routeSelectionExpression == null ? 43 : $routeSelectionExpression.hashCode());
        WebsocketRegistry $websocketRegistry = this.websocketRegistry;
        result = result * 59 + ($websocketRegistry == null ? 43 : $websocketRegistry.hashCode());
        return result;
    }

    @Generated
    private WebsocketsModule() {
    }
}

