/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.ChainException;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class MetaData {
    private final Map<String, Object> map;

    public static MetaData emptyMetaData() {
        return new MetaData(new HashMap<String, Object>());
    }

    public <T> void set(MetaDataKey<T> key, T value) {
        Validators.validateNotNull(key, "key");
        this.map.put(key.key(), value);
    }

    public void setUnchecked(MetaDataKey<?> key, Object value) {
        Validators.validateNotNull(key, "key");
        this.map.put(key.key(), value);
    }

    public <T> T get(MetaDataKey<T> key) {
        return this.getOptional(key).orElseThrow(() -> new RuntimeException(String.format("Could not find meta datum %s in %s", key.key(), this.map)));
    }

    public <T> T getOrSetDefault(MetaDataKey<T> key, Supplier<T> defaultProvider) {
        Optional<T> optional = this.getOptional(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        T defaultValue = defaultProvider.get();
        this.set(key, defaultValue);
        return defaultValue;
    }

    public <T> T getAs(MetaDataKey<? super T> key, Class<T> type) {
        T object = this.get(key);
        MetaData.ensureIsOfType(object, type, key);
        return object;
    }

    public <T> Optional<T> getOptional(MetaDataKey<T> key) {
        Object datum = this.map.get(key.key());
        return Optional.ofNullable(datum);
    }

    public <T> Optional<T> getOptionalAs(MetaDataKey<? super T> key, Class<T> type) {
        Optional<Object> optional = this.getOptional(key);
        optional.ifPresent(o -> MetaData.ensureIsOfType(o, type, key));
        return optional;
    }

    public boolean contains(MetaDataKey<?> key) {
        return this.getOptional(key).isPresent();
    }

    public String toString() {
        return this.prettyPrint();
    }

    public String prettyPrint() {
        return this.map.entrySet().stream().map(entry -> String.format("%s = %s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
    }

    private static void ensureIsOfType(Object object, Class<?> type, MetaDataKey<?> key) {
        if (!type.isInstance(object)) {
            throw ChainException.chainException(String.format("Object '%s' (%s) needs to be of type '%s'", object, key.key(), type.getName()));
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData other = (MetaData)o;
        Map<String, Object> this$map = this.map;
        Map<String, Object> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    @Generated
    private MetaData(Map<String, Object> map) {
        this.map = map;
    }
}

