/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.debug;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.http.ResponseHeaders;
import de.quantummaid.httpmaid.path.PathTemplate;
import lombok.Generated;

public final class DebugModule
implements ChainModule {
    private static final ChainName DEBUG_CHAIN = ChainName.chainName("DEBUG");
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.pathTemplate("/internals");

    public static ChainModule debugModule() {
        return new DebugModule();
    }

    @Override
    public void register(ChainExtender extender) {
        ChainRegistry registry = extender.getMetaDatum(ChainRegistry.CHAIN_REGISTRY);
        extender.createChain(DEBUG_CHAIN, Jump.jumpTo(HttpMaidChains.POST_PROCESS), Drop.drop());
        extender.appendProcessor(DEBUG_CHAIN, metaData -> {
            String dump = registry.dump();
            metaData.set(HttpMaidChainKeys.RESPONSE_BODY_STRING, dump);
            metaData.set(HttpMaidChainKeys.RESPONSE_STATUS, 200);
            metaData.set(HttpMaidChainKeys.RESPONSE_HEADERS, ResponseHeaders.emptyResponseHeaders());
        });
        extender.routeIf(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(DEBUG_CHAIN), HttpMaidChainKeys.PATH, PATH_TEMPLATE::matches, PATH_TEMPLATE.toString());
    }

    @Generated
    public String toString() {
        return "DebugModule()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof DebugModule;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private DebugModule() {
    }
}

