/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.QueryParametersBuilder;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketAuthorization;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketAuthorizationBuilder {
    private Headers headers;
    private QueryParameters queryParameters;
    private final Map<MetaDataKey<?>, Object> additionalMetaData = new LinkedHashMap();

    public static RawWebsocketAuthorizationBuilder rawWebsocketAuthorizationBuilder() {
        return new RawWebsocketAuthorizationBuilder();
    }

    public RawWebsocketAuthorizationBuilder withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public RawWebsocketAuthorizationBuilder withEncodedQueryString(String encodedQueryParameters) {
        return this.withQueryParameters(QueryParameters.fromQueryString(encodedQueryParameters));
    }

    public RawWebsocketAuthorizationBuilder withQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public RawWebsocketAuthorizationBuilder withQueryParameterMap(Map<String, List<String>> queryParameters) {
        QueryParametersBuilder builder = QueryParameters.builder();
        queryParameters.forEach(builder::withParameter);
        this.queryParameters = builder.build();
        return this;
    }

    public <T> RawWebsocketAuthorizationBuilder withAdditionalMetaData(MetaDataKey<T> key, T value) {
        this.additionalMetaData.put(key, value);
        return this;
    }

    public RawWebsocketAuthorization build() {
        return RawWebsocketAuthorization.rawWebsocketAuthorization(this.queryParameters, this.headers, this.additionalMetaData);
    }

    @Generated
    public String toString() {
        return "RawWebsocketAuthorizationBuilder(headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketAuthorizationBuilder)) {
            return false;
        }
        RawWebsocketAuthorizationBuilder other = (RawWebsocketAuthorizationBuilder)o;
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketAuthorizationBuilder() {
    }
}

