/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.util.streams.Streams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;

public final class RawResponse {
    private final MetaData metaData;

    public static RawResponse rawResponse(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        return new RawResponse(metaData);
    }

    public int status() {
        return this.metaData.get(HttpMaidChainKeys.RESPONSE_STATUS);
    }

    public Map<String, List<String>> headers() {
        return this.metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS).asStringMap();
    }

    public void setHeaders(BiConsumer<String, String> setter) {
        this.headers().forEach((key, values) -> values.forEach(value -> setter.accept((String)key, (String)value)));
    }

    public void streamBodyToOutputStream(OutputStream outputStream) {
        InputStream bodyStream = this.body();
        Streams.streamInputStreamToOutputStream(bodyStream, outputStream);
    }

    public InputStream body() {
        return this.metaData.getOptional(HttpMaidChainKeys.RESPONSE_STREAM).orElseGet(() -> Streams.stringToInputStream(""));
    }

    public Optional<String> optionalStringBody() {
        return this.metaData.getOptional(HttpMaidChainKeys.RESPONSE_STREAM).map(Streams::inputStreamToString);
    }

    public String stringBody() {
        return this.optionalStringBody().orElse("");
    }

    public MetaData metaData() {
        return this.metaData;
    }

    @Generated
    public String toString() {
        return "RawResponse(metaData=" + this.metaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawResponse)) {
            return false;
        }
        RawResponse other = (RawResponse)o;
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private RawResponse(MetaData metaData) {
        this.metaData = metaData;
    }
}

