/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.filtermap;

import de.quantummaid.httpmaid.filtermap.FilterMapEntry;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import lombok.Generated;

public final class FilterMap<F, T> {
    private final List<FilterMapEntry<F, T>> entries;
    private final T defaultValue;

    static <F, T> FilterMap<F, T> filterMap(List<FilterMapEntry<F, T>> entries, T defaultValue) {
        Validators.validateNotNull(entries, "entries");
        Validators.validateNotNull(defaultValue, "defaultValue");
        return new FilterMap<F, T>(entries, defaultValue);
    }

    public T get(F condition) {
        return (T)this.entries.stream().filter(entry -> entry.test(condition)).map(FilterMapEntry::value).findFirst().orElse(this.defaultValue);
    }

    @Generated
    private FilterMap(List<FilterMapEntry<F, T>> entries, T defaultValue) {
        this.entries = entries;
        this.defaultValue = defaultValue;
    }
}

