/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.generator;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.generator.Generator;
import de.quantummaid.httpmaid.generator.OverlappingConditionsException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class Generators<T> {
    private final List<Generator<T>> generators;

    public static <T> Generators<T> generators(List<Generator<T>> generators) {
        Validators.validateNotNull(generators, "generators");
        Generators.validateForConflicts(generators);
        return new Generators<T>(generators);
    }

    private static <T> void validateForConflicts(List<Generator<T>> generators) {
        for (int i = 0; i < generators.size(); ++i) {
            Generator<T> generatorA = generators.get(i);
            for (int j = i + 1; j < generators.size(); ++j) {
                Generator<T> generatorB = generators.get(j);
                if (!generatorA.isSubsetOf(generatorB)) continue;
                throw OverlappingConditionsException.overlappingConditionsException(generatorA, generatorB);
            }
        }
    }

    public Optional<T> generate(MetaData metaData) {
        return this.generators.stream().map(generator -> generator.generate(metaData)).filter(Optional::isPresent).map(Optional::orElseThrow).findFirst();
    }

    @Generated
    public String toString() {
        return "Generators(generators=" + this.generators + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Generators)) {
            return false;
        }
        Generators other = (Generators)o;
        List<Generator<T>> this$generators = this.generators;
        List<Generator<T>> other$generators = other.generators;
        return !(this$generators == null ? other$generators != null : !((Object)this$generators).equals(other$generators));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Generator<T>> $generators = this.generators;
        result = result * 59 + ($generators == null ? 43 : ((Object)$generators).hashCode());
        return result;
    }

    @Generated
    private Generators(List<Generator<T>> generators) {
        this.generators = generators;
    }
}

