/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.accept;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.accept.MimeType;
import de.quantummaid.httpmaid.http.headers.accept.MimeTypeMatcher;
import java.util.List;
import lombok.Generated;

public final class Accept {
    private final MimeTypeMatcher mimeTypeMatcher;

    public static Accept fromMetaData(MetaData metaData) {
        return metaData.getOptional(HttpMaidChainKeys.REQUEST_HEADERS).map(headers -> {
            List<String> mimeTypes = headers.allValuesFor("Accept");
            MimeTypeMatcher mimeTypeMatcher = mimeTypes.isEmpty() ? MimeTypeMatcher.anyMatcher() : MimeTypeMatcher.parseMimeTypeMatcher(mimeTypes);
            return new Accept(mimeTypeMatcher);
        }).orElseGet(() -> new Accept(MimeTypeMatcher.anyMatcher()));
    }

    public boolean contentTypeIsAccepted(ContentType contentType) {
        MimeType mimeType = MimeType.parseMimeType(contentType.internalValueForMapping());
        return this.mimeTypeMatcher.matches(mimeType);
    }

    @Generated
    public String toString() {
        return "Accept(mimeTypeMatcher=" + this.mimeTypeMatcher + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Accept)) {
            return false;
        }
        Accept other = (Accept)o;
        MimeTypeMatcher this$mimeTypeMatcher = this.mimeTypeMatcher;
        MimeTypeMatcher other$mimeTypeMatcher = other.mimeTypeMatcher;
        return !(this$mimeTypeMatcher == null ? other$mimeTypeMatcher != null : !((Object)this$mimeTypeMatcher).equals(other$mimeTypeMatcher));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MimeTypeMatcher $mimeTypeMatcher = this.mimeTypeMatcher;
        result = result * 59 + ($mimeTypeMatcher == null ? 43 : ((Object)$mimeTypeMatcher).hashCode());
        return result;
    }

    @Generated
    private Accept(MimeTypeMatcher mimeTypeMatcher) {
        this.mimeTypeMatcher = mimeTypeMatcher;
    }
}

