/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.path.PathException;
import de.quantummaid.httpmaid.path.statemachine.StateMachineMatcher;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

final class CaptureMatcher
implements StateMachineMatcher<String> {
    private static final Pattern PATTERN = Pattern.compile("<(.*)>");
    private final String name;

    static boolean isWildcard(String stringSpecification) {
        Matcher matcher = PATTERN.matcher(stringSpecification);
        return matcher.matches();
    }

    static StateMachineMatcher<String> fromStringSpecification(String stringSpecification) {
        Validators.validateNotNullNorEmpty(stringSpecification, "stringSpecification");
        Matcher matcher = PATTERN.matcher(stringSpecification);
        if (!matcher.matches()) {
            throw PathException.pathException("Not a wildcard: " + stringSpecification);
        }
        String name = matcher.group(1);
        return new CaptureMatcher(name);
    }

    @Override
    public Optional<Map<String, String>> matchAndReturnCaptures(String element) {
        return Optional.of(Map.of(this.name, element));
    }

    @Override
    public List<String> captures() {
        return List.of(this.name);
    }

    @Generated
    public String toString() {
        return "CaptureMatcher(name=" + this.name + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaptureMatcher)) {
            return false;
        }
        CaptureMatcher other = (CaptureMatcher)o;
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    private CaptureMatcher(String name) {
        this.name = name;
    }
}

