/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.oauth2;

import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authorization.AuthorizationHeader;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import lombok.Generated;

public final class OAuth2Authenticator
implements Authenticator<HttpRequest> {
    private final Authenticator<String> tokenAuthenticator;

    public static OAuth2Authenticator oAuth2Authenticator(Authenticator<String> tokenAuthenticator) {
        Validators.validateNotNull(tokenAuthenticator, "tokenAuthenticator");
        return new OAuth2Authenticator(tokenAuthenticator);
    }

    @Override
    public Optional<Object> authenticate(HttpRequest request) {
        return request.headers().optionalHeader("Authorization").flatMap(AuthorizationHeader::parse).filter(authorizationHeader -> authorizationHeader.type().equals("Bearer")).map(AuthorizationHeader::credentials).flatMap(this.tokenAuthenticator::authenticate);
    }

    @Generated
    public String toString() {
        return "OAuth2Authenticator(tokenAuthenticator=" + this.tokenAuthenticator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Authenticator)) {
            return false;
        }
        OAuth2Authenticator other = (OAuth2Authenticator)o;
        Authenticator<String> this$tokenAuthenticator = this.tokenAuthenticator;
        Authenticator<String> other$tokenAuthenticator = other.tokenAuthenticator;
        return !(this$tokenAuthenticator == null ? other$tokenAuthenticator != null : !this$tokenAuthenticator.equals(other$tokenAuthenticator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Authenticator<String> $tokenAuthenticator = this.tokenAuthenticator;
        result = result * 59 + ($tokenAuthenticator == null ? 43 : $tokenAuthenticator.hashCode());
        return result;
    }

    @Generated
    private OAuth2Authenticator(Authenticator<String> tokenAuthenticator) {
        this.tokenAuthenticator = tokenAuthenticator;
    }
}

