/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.util.describing.DescriptionUtils;
import de.quantummaid.httpmaid.util.describing.Dimensions;
import de.quantummaid.httpmaid.util.describing.EscapedText;
import de.quantummaid.httpmaid.util.describing.TextCanvas;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class CardBuilder {
    private String headline;
    private final Map<String, EscapedText> entries = new HashMap<String, EscapedText>();

    static CardBuilder cardBuilder() {
        return new CardBuilder();
    }

    void setHeadline(String headline) {
        Validators.validateNotNullNorEmpty(headline, "headline");
        this.headline = headline;
    }

    void addEntry(String key, String value) {
        Validators.validateNotNullNorEmpty(key, "key");
        Validators.validateNotNull(value, "value");
        EscapedText escapedValue = EscapedText.escapedText(value);
        this.entries.put(key, escapedValue);
    }

    public String build() {
        Dimensions dimensions = Dimensions.calculateDimensions(this.entries);
        TextCanvas canvas = TextCanvas.textCanvas(dimensions);
        canvas.draw(this.thickHorizontalLine(dimensions));
        String centeredTitle = CardBuilder.frame(DescriptionUtils.center(this.headline, dimensions.width() - 2));
        canvas.draw(centeredTitle);
        canvas.draw(this.thickHorizontalLine(dimensions));
        this.entries.forEach((key, value) -> {
            canvas.draw(CardBuilder.keyValue(key, value, dimensions));
            canvas.draw(this.thinHorizontalLine(dimensions));
        });
        return canvas.build();
    }

    private static String keyValue(String key, EscapedText value, Dimensions dimensions) {
        StringBuilder builder = new StringBuilder();
        List<String> renderedLines = value.renderLines(dimensions.lastRowLength());
        builder.append(CardBuilder.keyValueLine(key, CardBuilder.firstElement(renderedLines, ""), dimensions));
        for (int i = 1; i < renderedLines.size(); ++i) {
            builder.append("\n");
            String line = renderedLines.get(i);
            builder.append(CardBuilder.keyValueLine("", line, dimensions));
        }
        return builder.toString();
    }

    private static String keyValueLine(String key, String value, Dimensions dimensions) {
        StringBuilder builder = new StringBuilder();
        builder.append(" ");
        builder.append(DescriptionUtils.pad(key, dimensions.firstRowLength()));
        builder.append(" | ");
        builder.append(value);
        return CardBuilder.frame(DescriptionUtils.pad(builder.toString(), dimensions.width() - 2));
    }

    private String thickHorizontalLine(Dimensions dimensions) {
        return this.horizontalLine("=", dimensions);
    }

    private String thinHorizontalLine(Dimensions dimensions) {
        return this.horizontalLine("-", dimensions);
    }

    private String horizontalLine(String character, Dimensions dimensions) {
        int innerLength = dimensions.width() - 2;
        return CardBuilder.frame(DescriptionUtils.times(character, innerLength));
    }

    private static String frame(String string) {
        return String.format("%s%s%s", "|", string, "|");
    }

    private static <T> T firstElement(List<T> list, T alternative) {
        if (list.isEmpty()) {
            return alternative;
        }
        return list.get(0);
    }

    @Generated
    public String toString() {
        return "CardBuilder(headline=" + this.headline + ", entries=" + this.entries + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardBuilder)) {
            return false;
        }
        CardBuilder other = (CardBuilder)o;
        String this$headline = this.headline;
        String other$headline = other.headline;
        if (this$headline == null ? other$headline != null : !this$headline.equals(other$headline)) {
            return false;
        }
        Map<String, EscapedText> this$entries = this.entries;
        Map<String, EscapedText> other$entries = other.entries;
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $headline = this.headline;
        result = result * 59 + ($headline == null ? 43 : $headline.hashCode());
        Map<String, EscapedText> $entries = this.entries;
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    @Generated
    private CardBuilder() {
    }
}

