/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonSerializingSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonSerializingSender.class);
    private final WebsocketRegistry websocketRegistry;
    private final WebsocketSenders websocketSenders;
    private final MetaData metaData;

    public static NonSerializingSender nonSerializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, MetaData metaData) {
        return new NonSerializingSender(websocketRegistry, websocketSenders, metaData);
    }

    public void sendToAll(String message) {
        this.sendTo(message, WebsocketCriteria.websocketCriteria());
    }

    public void sendTo(String message, WebsocketCriteria criteria) {
        Validators.validateNotNull(message, "message");
        Validators.validateNotNull(criteria, "criteria");
        List<WebsocketRegistryEntry> connections = this.websocketRegistry.connections(criteria);
        Map<WebsocketSenderId, List<WebsocketRegistryEntry>> bySenderId = connections.stream().collect(Collectors.groupingBy(WebsocketRegistryEntry::getSenderId));
        bySenderId.forEach((websocketSenderId, websocketRegistryEntries) -> {
            List collectionInformations = websocketRegistryEntries.stream().map(WebsocketRegistryEntry::connectionInformation).collect(Collectors.toList());
            WebsocketSender<ConnectionInformation> sender = this.websocketSenders.senderById((WebsocketSenderId)websocketSenderId);
            sender.send(message, collectionInformations, (connectionInformation, throwable) -> {
                log.info("exception when sending to websocket {} - removing websocket; request metadata: {}", new Object[]{connectionInformation, this.metaData, throwable});
                this.websocketRegistry.removeConnection((ConnectionInformation)connectionInformation);
            });
        });
    }

    @Generated
    public String toString() {
        return "NonSerializingSender(websocketRegistry=" + this.websocketRegistry + ", websocketSenders=" + this.websocketSenders + ", metaData=" + this.metaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonSerializingSender)) {
            return false;
        }
        NonSerializingSender other = (NonSerializingSender)o;
        WebsocketRegistry this$websocketRegistry = this.websocketRegistry;
        WebsocketRegistry other$websocketRegistry = other.websocketRegistry;
        if (this$websocketRegistry == null ? other$websocketRegistry != null : !this$websocketRegistry.equals(other$websocketRegistry)) {
            return false;
        }
        WebsocketSenders this$websocketSenders = this.websocketSenders;
        WebsocketSenders other$websocketSenders = other.websocketSenders;
        if (this$websocketSenders == null ? other$websocketSenders != null : !((Object)this$websocketSenders).equals(other$websocketSenders)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebsocketRegistry $websocketRegistry = this.websocketRegistry;
        result = result * 59 + ($websocketRegistry == null ? 43 : $websocketRegistry.hashCode());
        WebsocketSenders $websocketSenders = this.websocketSenders;
        result = result * 59 + ($websocketSenders == null ? 43 : ((Object)$websocketSenders).hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private NonSerializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, MetaData metaData) {
        this.websocketRegistry = websocketRegistry;
        this.websocketSenders = websocketSenders;
        this.metaData = metaData;
    }
}

