/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.util.describing.EscapedText;
import java.util.Map;
import lombok.Generated;

final class Dimensions {
    private static final int MAX_WIDTH = 120;
    private static final int SLACK = 6;
    private final int width;
    private final int firstRowLength;
    private final int lastRowLength;

    static Dimensions calculateDimensions(Map<String, EscapedText> map) {
        Validators.validateNotNull(map, "map");
        int firstRowLength = Dimensions.keyLength(map);
        int lastRowLength = Dimensions.valueLength(map);
        int width = firstRowLength + lastRowLength + 6;
        return new Dimensions(width, firstRowLength, lastRowLength);
    }

    private static int keyLength(Map<String, EscapedText> map) {
        return map.keySet().stream().mapToInt(String::length).max().getAsInt();
    }

    private static int valueLength(Map<String, EscapedText> map) {
        int maxLineLength = map.values().stream().mapToInt(EscapedText::maxLineLength).max().getAsInt();
        return Math.min(maxLineLength, 120);
    }

    int width() {
        return this.width;
    }

    int firstRowLength() {
        return this.firstRowLength;
    }

    int lastRowLength() {
        return this.lastRowLength;
    }

    @Generated
    public String toString() {
        return "Dimensions(width=" + this.width + ", firstRowLength=" + this.firstRowLength + ", lastRowLength=" + this.lastRowLength + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)o;
        if (this.width != other.width) {
            return false;
        }
        if (this.firstRowLength != other.firstRowLength) {
            return false;
        }
        return this.lastRowLength == other.lastRowLength;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.width;
        result = result * 59 + this.firstRowLength;
        result = result * 59 + this.lastRowLength;
        return result;
    }

    @Generated
    private Dimensions(int width, int firstRowLength, int lastRowLength) {
        this.width = width;
        this.firstRowLength = firstRowLength;
        this.lastRowLength = lastRowLength;
    }
}

