/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.exceptions;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.exceptions.ExceptionMapper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionMapper.class);

    public static ExceptionMapper<Throwable> theDefaultExceptionMapper() {
        return new DefaultExceptionMapper();
    }

    @Override
    public void map(Throwable exception, MetaData metaData) {
        metaData.set(HttpMaidChainKeys.RESPONSE_STATUS, 500);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Exception during request processing\n{}", (Object)metaData.prettyPrint(), (Object)exception);
        }
    }

    @Generated
    private DefaultExceptionMapper() {
    }
}

