/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketMessage
implements RawRequest {
    private final ConnectionInformation connectionInformation;
    private final String body;
    private final Map<MetaDataKey<?>, Object> additionalMetaData;
    private final boolean restorationFromRegistryNeeded;
    private final QueryParameters queryParameters;
    private final Headers headers;
    private final Map<String, Object> additionalWebsocketData;

    public static RawWebsocketMessage rawWebsocketMessage(ConnectionInformation connectionInformation, String body) {
        return RawWebsocketMessage.rawWebsocketMessage(connectionInformation, body, Map.of());
    }

    public static RawWebsocketMessage rawWebsocketMessage(ConnectionInformation connectionInformation, String body, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(body, "body");
        Validators.validateNotNull(additionalMetaData, "additionalMetaData");
        return new RawWebsocketMessage(connectionInformation, body, additionalMetaData, true, null, null, null);
    }

    public static RawWebsocketMessage rawWebsocketMessageWithMetaData(ConnectionInformation connectionInformation, String body, QueryParameters queryParameters, Headers headers, Map<String, Object> additionalWebsocketData, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(body, "body");
        Validators.validateNotNull(headers, "headers");
        Validators.validateNotNull(queryParameters, "queryParameters");
        Validators.validateNotNull(additionalWebsocketData, "additionalWebsocketData");
        Validators.validateNotNull(additionalMetaData, "additionalMetaData");
        return new RawWebsocketMessage(connectionInformation, body, additionalMetaData, false, queryParameters, headers, additionalWebsocketData);
    }

    @Override
    public void enter(MetaData metaData) {
        metaData.set(WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_MESSAGE");
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, false);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION, this.connectionInformation);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STRING, this.body);
        this.additionalMetaData.forEach(metaData::setUnchecked);
        metaData.set(WebsocketMetaDataKeys.RESTORATION_FROM_REGISTRY_NEEDED, this.restorationFromRegistryNeeded);
        if (!this.restorationFromRegistryNeeded) {
            metaData.set(HttpMaidChainKeys.QUERY_PARAMETERS, this.queryParameters);
            metaData.set(HttpMaidChainKeys.REQUEST_HEADERS, this.headers);
            metaData.set(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, this.additionalWebsocketData);
        }
    }

    @Generated
    public String toString() {
        return "RawWebsocketMessage(connectionInformation=" + this.connectionInformation + ", body=" + this.body + ", additionalMetaData=" + this.additionalMetaData + ", restorationFromRegistryNeeded=" + this.restorationFromRegistryNeeded + ", queryParameters=" + this.queryParameters + ", headers=" + this.headers + ", additionalWebsocketData=" + this.additionalWebsocketData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketMessage)) {
            return false;
        }
        RawWebsocketMessage other = (RawWebsocketMessage)o;
        if (this.restorationFromRegistryNeeded != other.restorationFromRegistryNeeded) {
            return false;
        }
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        String this$body = this.body;
        String other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        if (this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$additionalWebsocketData = this.additionalWebsocketData;
        Map<String, Object> other$additionalWebsocketData = other.additionalWebsocketData;
        return !(this$additionalWebsocketData == null ? other$additionalWebsocketData != null : !((Object)this$additionalWebsocketData).equals(other$additionalWebsocketData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.restorationFromRegistryNeeded ? 79 : 97);
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        String $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $additionalWebsocketData = this.additionalWebsocketData;
        result = result * 59 + ($additionalWebsocketData == null ? 43 : ((Object)$additionalWebsocketData).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketMessage(ConnectionInformation connectionInformation, String body, Map<MetaDataKey<?>, Object> additionalMetaData, boolean restorationFromRegistryNeeded, QueryParameters queryParameters, Headers headers, Map<String, Object> additionalWebsocketData) {
        this.connectionInformation = connectionInformation;
        this.body = body;
        this.additionalMetaData = additionalMetaData;
        this.restorationFromRegistryNeeded = restorationFromRegistryNeeded;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.additionalWebsocketData = additionalWebsocketData;
    }
}

