/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;

public final class Origin {
    private final String origin;

    public static Optional<Origin> load(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        return metaData.get(HttpMaidChainKeys.REQUEST_HEADERS).getOptionalHeader("Origin").map(Origin::fromString);
    }

    public static Origin fromString(String origin) {
        Validators.validateNotNullNorEmpty(origin, "origin");
        return new Origin(origin);
    }

    public String internalValueForMapping() {
        return this.origin;
    }

    public String toString() {
        return "Origin(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)o;
        String this$origin = this.origin;
        String other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    private Origin(String origin) {
        this.origin = origin;
    }
}

