/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.endpoint;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawHttpRequest;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.streams.Streams;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class RawHttpRequestBuilder {
    private String path;
    private String requestMethod;
    private Headers headers;
    private QueryParameters queryParameters;
    private InputStream body;
    private final Map<MetaDataKey<?>, Object> additionalMetaData = new HashMap();

    public static RawHttpRequestBuilder rawHttpRequestBuilder() {
        return new RawHttpRequestBuilder();
    }

    public RawHttpRequestBuilder withUri(URI uri) {
        this.withPath(uri.getPath());
        this.withQueryString(uri.getRawQuery());
        return this;
    }

    public RawHttpRequestBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public RawHttpRequestBuilder withMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public RawHttpRequestBuilder withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public RawHttpRequestBuilder withQueryString(String encodedQueryParameters) {
        return this.withQueryParameters(QueryParameters.fromQueryString(encodedQueryParameters));
    }

    public RawHttpRequestBuilder withQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public RawHttpRequestBuilder withBody(String body) {
        InputStream stream = Streams.stringToInputStream(body);
        return this.withBody(stream);
    }

    public RawHttpRequestBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public <T> RawHttpRequestBuilder withAdditionalMetaData(MetaDataKey<T> key, T value) {
        this.additionalMetaData.put(key, value);
        return this;
    }

    public RawHttpRequest build() {
        if (this.body == null) {
            this.withBody("");
        }
        return RawHttpRequest.rawHttpRequest(this.path, this.requestMethod, this.headers, this.queryParameters, this.body, this.additionalMetaData);
    }

    @Generated
    public String toString() {
        return "RawHttpRequestBuilder(path=" + this.path + ", requestMethod=" + this.requestMethod + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", body=" + this.body + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawHttpRequestBuilder)) {
            return false;
        }
        RawHttpRequestBuilder other = (RawHttpRequestBuilder)o;
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$requestMethod = this.requestMethod;
        String other$requestMethod = other.requestMethod;
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        InputStream this$body = this.body;
        InputStream other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $requestMethod = this.requestMethod;
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        InputStream $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawHttpRequestBuilder() {
    }
}

