/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.generator;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import lombok.Generated;

public final class Generator<T> {
    private final T value;
    private final GenerationCondition condition;

    public static <T> Generator<T> generator(T value, GenerationCondition condition) {
        Validators.validateNotNull(value, "value");
        Validators.validateNotNull(condition, "condition");
        return new Generator<T>(value, condition);
    }

    boolean isSubsetOf(Generator<T> other) {
        Validators.validateNotNull(other, "other");
        return this.condition.isSubsetOf(other.condition);
    }

    Optional<T> generate(MetaData metaData) {
        if (this.condition.generate(metaData)) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "Generator(value=" + this.value + ", condition=" + this.condition + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Generator)) {
            return false;
        }
        Generator other = (Generator)o;
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        GenerationCondition this$condition = this.condition;
        GenerationCondition other$condition = other.condition;
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        GenerationCondition $condition = this.condition;
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }

    @Generated
    private Generator(T value, GenerationCondition condition) {
        this.value = value;
        this.condition = condition;
    }
}

