/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class HeadersBuilder {
    private final List<Header> headers;

    public static HeadersBuilder headersBuilder() {
        return new HeadersBuilder(new ArrayList<Header>());
    }

    public void withAdditionalHeader(String key, List<String> values) {
        values.forEach(value -> this.withAdditionalHeader(key, (String)value));
    }

    public void withAdditionalHeader(String key, String value) {
        Header header = Header.header(HeaderName.headerName(key), HeaderValue.headerValue(value));
        this.headers.add(header);
    }

    public void withHeadersMap(Map<String, List<String>> map) {
        map.forEach(this::withAdditionalHeader);
    }

    public Headers build() {
        return Headers.headers(this.headers);
    }

    @Generated
    public String toString() {
        return "HeadersBuilder(headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeadersBuilder)) {
            return false;
        }
        HeadersBuilder other = (HeadersBuilder)o;
        List<Header> this$headers = this.headers;
        List<Header> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Header> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    private HeadersBuilder(List<Header> headers) {
        this.headers = headers;
    }
}

