/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath.statemachine;

import de.quantummaid.httpmaid.mappath.MapPathElement;
import de.quantummaid.httpmaid.mappath.MapPathException;
import de.quantummaid.httpmaid.mappath.statemachine.Transition;
import de.quantummaid.httpmaid.mappath.statemachine.states.ErrorState;
import de.quantummaid.httpmaid.mappath.statemachine.states.KeyState;
import de.quantummaid.httpmaid.mappath.statemachine.states.State;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class StateMachine {
    private final String input;
    private State state = KeyState.keyState();
    private final List<MapPathElement> elements = new ArrayList<MapPathElement>();

    public static List<MapPathElement> runStateMachineOn(String input) {
        StateMachine stateMachine = new StateMachine(input);
        stateMachine.run();
        return stateMachine.elements;
    }

    private void run() {
        int index;
        char[] chars = this.input.toCharArray();
        for (index = 0; index < chars.length; ++index) {
            Character c = Character.valueOf(chars[index]);
            Transition transition = this.dispatch(c);
            this.handleTransition(transition, index);
        }
        Transition endTransition = this.state.handleEnd();
        this.handleTransition(endTransition, index);
    }

    private Transition dispatch(Character c) {
        if (c == null) {
            return this.state.handleEnd();
        }
        if (c.charValue() == '[') {
            return this.state.handleOpeningSquareBrackets();
        }
        if (c.charValue() == ']') {
            return this.state.handleClosingSquareBrackets();
        }
        if (c.charValue() == '.') {
            return this.state.handleDot();
        }
        if (Character.isDigit(c.charValue())) {
            return this.state.handleNumericCharacter(c.charValue());
        }
        if (c.charValue() == '\n') {
            return this.state.handleNewline();
        }
        return this.state.handleNonNumericCharacter(c.charValue());
    }

    private void handleTransition(Transition transition, int index) {
        transition.mapPathElement().ifPresent(this.elements::add);
        this.state = transition.nextState();
        if (this.state instanceof ErrorState) {
            ErrorState errorState = (ErrorState)this.state;
            String message = errorState.message();
            throw MapPathException.parseException(message, this.input, index);
        }
    }

    @Generated
    private StateMachine(String input) {
        this.input = input;
    }
}

