/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers;

import de.quantummaid.httpmaid.http.headers.HeaderValueWithComment;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class ContentType {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String JSON = "application/json";
    private static final String XML = "application/xml";
    private static final String YAML = "application/yaml";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private final HeaderValueWithComment value;

    public static ContentType fromString(Optional<String> value) {
        return value.map(raw -> {
            HeaderValueWithComment header = HeaderValueWithComment.fromString(raw);
            return new ContentType(header);
        }).orElseGet(ContentType::empty);
    }

    private static ContentType empty() {
        return new ContentType(null);
    }

    public static ContentType fromString(String contentType) {
        Validators.validateNotNull(contentType, "content-type");
        return ContentType.fromString(Optional.of(contentType));
    }

    public static ContentType json() {
        return ContentType.fromString(JSON);
    }

    public static ContentType xml() {
        return ContentType.fromString(XML);
    }

    public static ContentType yaml() {
        return ContentType.fromString(YAML);
    }

    public static ContentType formUrlEncoded() {
        return ContentType.fromString(FORM_URLENCODED);
    }

    public static ContentType textPlain() {
        return ContentType.fromString(TEXT_PLAIN);
    }

    public boolean isEmpty() {
        return Objects.isNull(this.value);
    }

    public String comment() {
        return this.value.comment();
    }

    public String valueWithComment() {
        return this.value.valueWithComment();
    }

    public String internalValueForMapping() {
        return Optional.ofNullable(this.value).map(HeaderValueWithComment::value).orElse("");
    }

    @Generated
    public String toString() {
        return "ContentType(value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentType)) {
            return false;
        }
        ContentType other = (ContentType)o;
        HeaderValueWithComment this$value = this.value;
        HeaderValueWithComment other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HeaderValueWithComment $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    private ContentType(HeaderValueWithComment value) {
        this.value = value;
    }
}

