/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.autoloading;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.autoloading.AutoloadingException;
import de.quantummaid.httpmaid.util.Validators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public final class Autoloader {
    private Autoloader() {
    }

    public static Optional<ChainModule> loadModule(String fullyQualifiedClassName) {
        Validators.validateNotNullNorEmpty(fullyQualifiedClassName, "fullyQualifiedClassName");
        return Autoloader.loadClass(fullyQualifiedClassName).map(clazz -> {
            Method staticInitializer = Autoloader.findStaticInitializer(clazz);
            return Autoloader.invoke(staticInitializer);
        });
    }

    private static Optional<Class<? extends ChainModule>> loadClass(String fullyQualifiedClassName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(fullyQualifiedClassName);
            return Optional.of(clazz);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static Method findStaticInitializer(Class<? extends ChainModule> clazz) {
        Method[] methods = clazz.getMethods();
        return Arrays.stream(methods).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(clazz)).filter(method -> method.getParameterCount() == 0).findFirst().orElseThrow();
    }

    private static ChainModule invoke(Method staticInitializer) {
        try {
            return (ChainModule)staticInitializer.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw AutoloadingException.autoloadingException(e);
        }
    }
}

