/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class WebsocketRegistryEntry {
    private final ConnectionInformation connectionInformation;
    private final WebsocketSenderId senderId;
    private final Headers headers;
    private final ContentType contentType;
    private final QueryParameters queryParameters;
    private final Map<String, Object> additionalData;

    public static WebsocketRegistryEntry websocketRegistryEntry(ConnectionInformation connectionInformation, WebsocketSenderId senderId, Headers headers, ContentType contentType, QueryParameters queryParameters, Map<String, Object> additionalData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(senderId, "senderId");
        Validators.validateNotNull(headers, "headers");
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(queryParameters, "queryParameters");
        Validators.validateNotNull(additionalData, "additionalData");
        return new WebsocketRegistryEntry(connectionInformation, senderId, headers, contentType, queryParameters, additionalData);
    }

    public static WebsocketRegistryEntry loadFromMetaData(MetaData metaData) {
        ConnectionInformation connectionInformation = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION);
        WebsocketSenderId senderId = metaData.get(WebsocketSenderId.WEBSOCKET_SENDER_ID);
        Headers headers = metaData.get(HttpMaidChainKeys.REQUEST_HEADERS);
        ContentType contentType = metaData.get(HttpMaidChainKeys.REQUEST_CONTENT_TYPE);
        QueryParameters queryParameters = metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS);
        Map<String, Object> additionalData = metaData.get(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA);
        return WebsocketRegistryEntry.websocketRegistryEntry(connectionInformation, senderId, headers, contentType, queryParameters, additionalData);
    }

    public static WebsocketRegistryEntry restoreFromStrings(ConnectionInformation connectionInformation, String senderId, Headers headers, Optional<String> contentType, QueryParameters queryParameters, Map<String, Object> additionalData) {
        WebsocketSenderId websocketSenderId = WebsocketSenderId.websocketSenderId(senderId);
        ContentType contentTypeObject = ContentType.fromString(contentType);
        return WebsocketRegistryEntry.websocketRegistryEntry(connectionInformation, websocketSenderId, headers, contentTypeObject, queryParameters, additionalData);
    }

    public WebsocketSenderId senderId() {
        return this.senderId;
    }

    public ConnectionInformation connectionInformation() {
        return this.connectionInformation;
    }

    public WebsocketSenderId getSenderId() {
        return this.senderId;
    }

    public Headers headers() {
        return this.headers;
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public QueryParameters queryParameters() {
        return this.queryParameters;
    }

    public Map<String, Object> additionalData() {
        return this.additionalData;
    }

    public void restoreToMetaData(MetaData metaData) {
        metaData.set(HttpMaidChainKeys.REQUEST_HEADERS, this.headers);
        metaData.set(HttpMaidChainKeys.REQUEST_CONTENT_TYPE, this.contentType);
        metaData.set(HttpMaidChainKeys.QUERY_PARAMETERS, this.queryParameters);
        metaData.set(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, this.additionalData);
    }

    @Generated
    public String toString() {
        return "WebsocketRegistryEntry(connectionInformation=" + this.connectionInformation + ", senderId=" + this.getSenderId() + ", headers=" + this.headers + ", contentType=" + this.contentType + ", queryParameters=" + this.queryParameters + ", additionalData=" + this.additionalData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketRegistryEntry)) {
            return false;
        }
        WebsocketRegistryEntry other = (WebsocketRegistryEntry)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$senderId = this.getSenderId();
        WebsocketSenderId other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !((Object)this$senderId).equals(other$senderId)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        ContentType this$contentType = this.contentType;
        ContentType other$contentType = other.contentType;
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Map<String, Object> this$additionalData = this.additionalData;
        Map<String, Object> other$additionalData = other.additionalData;
        return !(this$additionalData == null ? other$additionalData != null : !((Object)this$additionalData).equals(other$additionalData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : ((Object)$senderId).hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        ContentType $contentType = this.contentType;
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Map<String, Object> $additionalData = this.additionalData;
        result = result * 59 + ($additionalData == null ? 43 : ((Object)$additionalData).hashCode());
        return result;
    }

    @Generated
    private WebsocketRegistryEntry(ConnectionInformation connectionInformation, WebsocketSenderId senderId, Headers headers, ContentType contentType, QueryParameters queryParameters, Map<String, Object> additionalData) {
        this.connectionInformation = connectionInformation;
        this.senderId = senderId;
        this.headers = headers;
        this.contentType = contentType;
        this.queryParameters = queryParameters;
        this.additionalData = additionalData;
    }
}

