/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketsModule;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;

public final class WebsocketConfigurators {
    private WebsocketConfigurators() {
    }

    public static Configurator toStoreAdditionalDataInWebsocketContext(AdditionalWebsocketDataProvider dataProvider) {
        Validators.validateNotNull(dataProvider, "dataProvider");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setAdditionalWebsocketDataProvider(dataProvider));
    }

    public static Configurator toSelectWebsocketRoutesBasedOn(String routeSelectionExpression) {
        Validators.validateNotNull(routeSelectionExpression, "routeSelectionExpression");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setRouteSelectionExpression(routeSelectionExpression));
    }

    public static Configurator toUseWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketRegistry(websocketRegistry));
    }

    public static Configurator toAuthorizeWebsocketsUsing(WebsocketAuthorizer authorizer) {
        Validators.validateNotNull(authorizer, "authorizer");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketAuthorizer(authorizer));
    }
}

