/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import de.quantummaid.httpmaid.websockets.processors.AddAdditionalWebsocketDataProcessor;
import de.quantummaid.httpmaid.websockets.processors.AddWebsocketsMetaDataProcessor;
import de.quantummaid.httpmaid.websockets.processors.AuthorizeWebsocketProcessor;
import de.quantummaid.httpmaid.websockets.processors.DetermineWebsocketRouteProcessor;
import de.quantummaid.httpmaid.websockets.processors.PutWebsocketInRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RemoveWebsocketFromRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RestoreWebsocketContextInformationProcessor;
import de.quantummaid.httpmaid.websockets.registry.InMemoryRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.Map;
import lombok.Generated;

public final class WebsocketsModule
implements ChainModule {
    private static final ChainName AUTHORIZE_WEBSOCKET = ChainName.chainName("AUTHORIZE_WEBSOCKET");
    private static final ChainName CONNECT_WEBSOCKET = ChainName.chainName("CONNECT_WEBSOCKET");
    private static final ChainName DISCONNECT_WEBSOCKET = ChainName.chainName("DISCONNECT_WEBSOCKET");
    private String routeSelectionExpression = "message";
    private WebsocketRegistry websocketRegistry = InMemoryRegistry.inMemoryRegistry();
    private AdditionalWebsocketDataProvider additionalWebsocketDataProvider = request -> Map.of();
    private WebsocketAuthorizer websocketAuthorizer = request -> AuthorizationDecision.success();

    public static WebsocketsModule websocketsModule() {
        return new WebsocketsModule();
    }

    public void setRouteSelectionExpression(String routeSelectionExpression) {
        this.routeSelectionExpression = routeSelectionExpression;
    }

    public void setWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        this.websocketRegistry = websocketRegistry;
    }

    public void setAdditionalWebsocketDataProvider(AdditionalWebsocketDataProvider additionalWebsocketDataProvider) {
        this.additionalWebsocketDataProvider = additionalWebsocketDataProvider;
    }

    public void setWebsocketAuthorizer(WebsocketAuthorizer websocketAuthorizer) {
        this.websocketAuthorizer = websocketAuthorizer;
    }

    @Override
    public void register(ChainExtender extender) {
        extender.addMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY, this.websocketRegistry);
        WebsocketSenders websocketSenders = extender.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        extender.appendProcessor(HttpMaidChains.INIT, AddWebsocketsMetaDataProcessor.addWebsocketRegistryProcessor(websocketSenders, this.websocketRegistry));
        extender.appendProcessor(HttpMaidChains.PRE_PROCESS, RestoreWebsocketContextInformationProcessor.restoreWebsocketContextInformationProcessor());
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(AUTHORIZE_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_AUTHORIZATION");
        extender.createChain(AUTHORIZE_WEBSOCKET, Consume.consume(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(AUTHORIZE_WEBSOCKET, AuthorizeWebsocketProcessor.authorizeWebsocketProcessor(this.websocketAuthorizer));
        extender.appendProcessor(AUTHORIZE_WEBSOCKET, AddAdditionalWebsocketDataProcessor.addAdditionalWebsocketDataProcessor(this.additionalWebsocketDataProvider));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(CONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_CONNECT");
        extender.createChain(CONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(CONNECT_WEBSOCKET, PutWebsocketInRegistryProcessor.putWebsocketInRegistryProcessor());
        extender.appendProcessor(HttpMaidChains.PRE_DETERMINE_HANDLER, DetermineWebsocketRouteProcessor.determineWebsocketRouteProcessor(this.routeSelectionExpression));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(DISCONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_DISCONNECT");
        extender.createChain(DISCONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(DISCONNECT_WEBSOCKET, RemoveWebsocketFromRegistryProcessor.removeWebsocketFromRegistryProcessor());
    }

    @Generated
    public String toString() {
        return "WebsocketsModule(routeSelectionExpression=" + this.routeSelectionExpression + ", websocketRegistry=" + this.websocketRegistry + ", additionalWebsocketDataProvider=" + this.additionalWebsocketDataProvider + ", websocketAuthorizer=" + this.websocketAuthorizer + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketsModule)) {
            return false;
        }
        WebsocketsModule other = (WebsocketsModule)o;
        String this$routeSelectionExpression = this.routeSelectionExpression;
        String other$routeSelectionExpression = other.routeSelectionExpression;
        if (this$routeSelectionExpression == null ? other$routeSelectionExpression != null : !this$routeSelectionExpression.equals(other$routeSelectionExpression)) {
            return false;
        }
        WebsocketRegistry this$websocketRegistry = this.websocketRegistry;
        WebsocketRegistry other$websocketRegistry = other.websocketRegistry;
        if (this$websocketRegistry == null ? other$websocketRegistry != null : !this$websocketRegistry.equals(other$websocketRegistry)) {
            return false;
        }
        AdditionalWebsocketDataProvider this$additionalWebsocketDataProvider = this.additionalWebsocketDataProvider;
        AdditionalWebsocketDataProvider other$additionalWebsocketDataProvider = other.additionalWebsocketDataProvider;
        if (this$additionalWebsocketDataProvider == null ? other$additionalWebsocketDataProvider != null : !this$additionalWebsocketDataProvider.equals(other$additionalWebsocketDataProvider)) {
            return false;
        }
        WebsocketAuthorizer this$websocketAuthorizer = this.websocketAuthorizer;
        WebsocketAuthorizer other$websocketAuthorizer = other.websocketAuthorizer;
        return !(this$websocketAuthorizer == null ? other$websocketAuthorizer != null : !this$websocketAuthorizer.equals(other$websocketAuthorizer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routeSelectionExpression = this.routeSelectionExpression;
        result = result * 59 + ($routeSelectionExpression == null ? 43 : $routeSelectionExpression.hashCode());
        WebsocketRegistry $websocketRegistry = this.websocketRegistry;
        result = result * 59 + ($websocketRegistry == null ? 43 : $websocketRegistry.hashCode());
        AdditionalWebsocketDataProvider $additionalWebsocketDataProvider = this.additionalWebsocketDataProvider;
        result = result * 59 + ($additionalWebsocketDataProvider == null ? 43 : $additionalWebsocketDataProvider.hashCode());
        WebsocketAuthorizer $websocketAuthorizer = this.websocketAuthorizer;
        result = result * 59 + ($websocketAuthorizer == null ? 43 : $websocketAuthorizer.hashCode());
        return result;
    }

    @Generated
    private WebsocketsModule() {
    }
}

