/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InMemoryRegistry
implements WebsocketRegistry {
    private final List<WebsocketRegistryEntry> entries;

    public static InMemoryRegistry inMemoryRegistry() {
        return new InMemoryRegistry(new ArrayList<WebsocketRegistryEntry>());
    }

    @Override
    public synchronized List<WebsocketRegistryEntry> connections(WebsocketCriteria criteria) {
        return this.entries.stream().filter(criteria::filter).collect(Collectors.toList());
    }

    @Override
    public synchronized WebsocketRegistryEntry byConnectionInformation(ConnectionInformation connectionInformation) {
        return this.entries.stream().filter(entry -> entry.connectionInformation().equals(connectionInformation)).findFirst().orElseThrow(() -> new RuntimeException(String.format("No websocket registered by '%s'", connectionInformation)));
    }

    @Override
    public synchronized void addConnection(WebsocketRegistryEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public synchronized void removeConnection(ConnectionInformation connectionInformation) {
        List entriesToRemove = this.entries.stream().filter(entry -> entry.connectionInformation().equals(connectionInformation)).collect(Collectors.toList());
        this.entries.removeAll(entriesToRemove);
    }

    @Override
    public long countConnections() {
        return this.entries.size();
    }

    @Generated
    public String toString() {
        return "InMemoryRegistry(entries=" + this.entries + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InMemoryRegistry)) {
            return false;
        }
        InMemoryRegistry other = (InMemoryRegistry)o;
        List<WebsocketRegistryEntry> this$entries = this.entries;
        List<WebsocketRegistryEntry> other$entries = other.entries;
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WebsocketRegistryEntry> $entries = this.entries;
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    @Generated
    private InMemoryRegistry(List<WebsocketRegistryEntry> entries) {
        this.entries = entries;
    }
}

