/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.policy;

import de.quantummaid.httpmaid.cors.domain.ExposedHeaders;
import de.quantummaid.httpmaid.cors.domain.MaxAge;
import de.quantummaid.httpmaid.cors.domain.Origin;
import de.quantummaid.httpmaid.cors.domain.RequestedHeader;
import de.quantummaid.httpmaid.cors.domain.RequestedHeaders;
import de.quantummaid.httpmaid.cors.domain.RequestedMethod;
import de.quantummaid.httpmaid.cors.policy.AllowedHeaders;
import de.quantummaid.httpmaid.cors.policy.AllowedMethods;
import de.quantummaid.httpmaid.cors.policy.AllowedOrigins;
import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class ResourceSharingPolicy {
    private final AllowedOrigins allowedOrigins;
    private final AllowedMethods allowedMethods;
    private final AllowedHeaders allowedHeaders;
    private final ExposedHeaders exposedHeaders;
    private final boolean supportsCredentials;
    private final MaxAge maxAge;

    public static ResourceSharingPolicy resourceSharingPolicy(AllowedOrigins allowedOrigins, AllowedMethods allowedMethods, AllowedHeaders allowedHeaders, ExposedHeaders exposedHeaders, boolean supportsCredentials, MaxAge maxAge) {
        Validators.validateNotNull(allowedOrigins, "allowedOrigins");
        Validators.validateNotNull(allowedMethods, "allowedMethods");
        Validators.validateNotNull(allowedHeaders, "allowedHeaders");
        Validators.validateNotNull(exposedHeaders, "exposedHeaders");
        Validators.validateNotNull(maxAge, "maxAge");
        return new ResourceSharingPolicy(allowedOrigins, allowedMethods, allowedHeaders, exposedHeaders, supportsCredentials, maxAge);
    }

    public boolean validateOrigin(Origin origin) {
        Validators.validateNotNull(origin, "origin");
        return this.allowedOrigins.isAllowed(origin);
    }

    public boolean validateRequestedMethod(RequestedMethod requestedMethod) {
        Validators.validateNotNull(requestedMethod, "requestedMethod");
        return this.allowedMethods.isAllowed(requestedMethod);
    }

    public boolean validateRequestedHeaders(RequestedHeaders requestedHeaders) {
        Validators.validateNotNull(requestedHeaders, "requestedHeaders");
        for (RequestedHeader header : requestedHeaders.headers()) {
            if (this.allowedHeaders.isAllowed(header)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsCredentials() {
        return this.supportsCredentials;
    }

    public ExposedHeaders exposedHeaders() {
        return this.exposedHeaders;
    }

    public MaxAge maxAge() {
        return this.maxAge;
    }

    @Generated
    public String toString() {
        return "ResourceSharingPolicy(allowedOrigins=" + this.allowedOrigins + ", allowedMethods=" + this.allowedMethods + ", allowedHeaders=" + this.allowedHeaders + ", exposedHeaders=" + this.exposedHeaders + ", supportsCredentials=" + this.supportsCredentials + ", maxAge=" + this.maxAge + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceSharingPolicy)) {
            return false;
        }
        ResourceSharingPolicy other = (ResourceSharingPolicy)o;
        if (this.supportsCredentials != other.supportsCredentials) {
            return false;
        }
        AllowedOrigins this$allowedOrigins = this.allowedOrigins;
        AllowedOrigins other$allowedOrigins = other.allowedOrigins;
        if (this$allowedOrigins == null ? other$allowedOrigins != null : !this$allowedOrigins.equals(other$allowedOrigins)) {
            return false;
        }
        AllowedMethods this$allowedMethods = this.allowedMethods;
        AllowedMethods other$allowedMethods = other.allowedMethods;
        if (this$allowedMethods == null ? other$allowedMethods != null : !this$allowedMethods.equals(other$allowedMethods)) {
            return false;
        }
        AllowedHeaders this$allowedHeaders = this.allowedHeaders;
        AllowedHeaders other$allowedHeaders = other.allowedHeaders;
        if (this$allowedHeaders == null ? other$allowedHeaders != null : !this$allowedHeaders.equals(other$allowedHeaders)) {
            return false;
        }
        ExposedHeaders this$exposedHeaders = this.exposedHeaders;
        ExposedHeaders other$exposedHeaders = other.exposedHeaders;
        if (this$exposedHeaders == null ? other$exposedHeaders != null : !((Object)this$exposedHeaders).equals(other$exposedHeaders)) {
            return false;
        }
        MaxAge this$maxAge = this.maxAge;
        MaxAge other$maxAge = other.maxAge;
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.supportsCredentials ? 79 : 97);
        AllowedOrigins $allowedOrigins = this.allowedOrigins;
        result = result * 59 + ($allowedOrigins == null ? 43 : $allowedOrigins.hashCode());
        AllowedMethods $allowedMethods = this.allowedMethods;
        result = result * 59 + ($allowedMethods == null ? 43 : $allowedMethods.hashCode());
        AllowedHeaders $allowedHeaders = this.allowedHeaders;
        result = result * 59 + ($allowedHeaders == null ? 43 : $allowedHeaders.hashCode());
        ExposedHeaders $exposedHeaders = this.exposedHeaders;
        result = result * 59 + ($exposedHeaders == null ? 43 : ((Object)$exposedHeaders).hashCode());
        MaxAge $maxAge = this.maxAge;
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    @Generated
    private ResourceSharingPolicy(AllowedOrigins allowedOrigins, AllowedMethods allowedMethods, AllowedHeaders allowedHeaders, ExposedHeaders exposedHeaders, boolean supportsCredentials, MaxAge maxAge) {
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
        this.supportsCredentials = supportsCredentials;
        this.maxAge = maxAge;
    }
}

