/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath.statemachine.states;

import de.quantummaid.httpmaid.mappath.KeyMapPathElement;
import de.quantummaid.httpmaid.mappath.MapPathElement;
import de.quantummaid.httpmaid.mappath.statemachine.Transition;
import de.quantummaid.httpmaid.mappath.statemachine.states.ErrorState;
import de.quantummaid.httpmaid.mappath.statemachine.states.IndexState;
import de.quantummaid.httpmaid.mappath.statemachine.states.State;
import de.quantummaid.httpmaid.mappath.statemachine.states.SuccessState;
import java.util.Optional;
import lombok.Generated;

public final class KeyState
implements State {
    private final StringBuilder stringBuilder;

    public static KeyState keyState() {
        return new KeyState(new StringBuilder());
    }

    @Override
    public Transition handleOpeningSquareBrackets() {
        return this.buildElement().map(element -> Transition.transitionTo(IndexState.indexState(), element)).orElseGet(this::emptyKeyError);
    }

    @Override
    public Transition handleClosingSquareBrackets() {
        return Transition.transitionTo(ErrorState.errorState("square brackets are closed without opening them before"));
    }

    @Override
    public Transition handleDot() {
        return this.buildElement().map(element -> Transition.transitionTo(KeyState.keyState(), element)).orElseGet(this::emptyKeyError);
    }

    @Override
    public Transition handleNumericCharacter(char c) {
        return this.handleNonNumericCharacter(c);
    }

    @Override
    public Transition handleNonNumericCharacter(char c) {
        this.stringBuilder.append(c);
        return Transition.transitionTo(this);
    }

    @Override
    public Transition handleEnd() {
        return this.buildElement().map(element -> Transition.transitionTo(SuccessState.successState(), element)).orElseGet(this::emptyKeyError);
    }

    private Optional<MapPathElement> buildElement() {
        if (this.stringBuilder.length() == 0) {
            return Optional.empty();
        }
        String key = this.stringBuilder.toString();
        return Optional.of(KeyMapPathElement.keyMapPathElement(key));
    }

    private Transition emptyKeyError() {
        return Transition.transitionTo(ErrorState.errorState("key is empty"));
    }

    @Generated
    public String toString() {
        return "KeyState(stringBuilder=" + this.stringBuilder + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyState)) {
            return false;
        }
        KeyState other = (KeyState)o;
        StringBuilder this$stringBuilder = this.stringBuilder;
        StringBuilder other$stringBuilder = other.stringBuilder;
        return !(this$stringBuilder == null ? other$stringBuilder != null : !this$stringBuilder.equals(other$stringBuilder));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $stringBuilder = this.stringBuilder;
        result = result * 59 + ($stringBuilder == null ? 43 : $stringBuilder.hashCode());
        return result;
    }

    @Generated
    private KeyState(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }
}

