/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.accept.Accept;
import de.quantummaid.httpmaid.marshalling.DefaultContentTypeProvider;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.ResponseContentTypeCouldNotBeDeterminedException;
import de.quantummaid.httpmaid.marshalling.UnsupportedContentTypeException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Marshallers {
    public static final MetaDataKey<Marshallers> MARSHALLERS = MetaDataKey.metaDataKey("MARSHALLERS");
    private final Map<ContentType, Marshaller> marshallersMap;
    private final DefaultContentTypeProvider defaultContentTypeProvider;

    public static Marshallers marshallers(Map<ContentType, Marshaller> marshallers, DefaultContentTypeProvider defaultContentTypeProvider) {
        return new Marshallers(marshallers, defaultContentTypeProvider);
    }

    public boolean isEmpty() {
        return this.marshallersMap.isEmpty();
    }

    public Marshaller marshallerFor(ContentType responseContentType) {
        Marshaller marshaller = this.marshallersMap.get(responseContentType);
        if (Objects.isNull(marshaller)) {
            throw UnsupportedContentTypeException.unsupportedContentTypeException(responseContentType, this.marshallersMap.keySet());
        }
        return marshaller;
    }

    public Marshaller determineResponseMarshaller(MetaData metaData) {
        ContentType responseContentType = this.determineResponseContentType(metaData);
        return this.marshallerFor(responseContentType);
    }

    public ContentType determineResponseContentType(MetaData metaData) {
        Optional<ContentType> responseContentType = Marshallers.responseContentType(metaData);
        if (responseContentType.isPresent()) {
            return responseContentType.get();
        }
        Accept accept = Accept.fromMetaData(metaData);
        List candidates = this.marshallersMap.keySet().stream().filter(accept::contentTypeIsAccepted).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return this.defaultResponseContentType(metaData).orElseThrow(() -> ResponseContentTypeCouldNotBeDeterminedException.responseContentTypeCouldNotBeDeterminedException(metaData));
        }
        Optional<ContentType> requestContentType = metaData.getOptional(HttpMaidChainKeys.REQUEST_CONTENT_TYPE).filter(candidates::contains);
        if (requestContentType.isPresent()) {
            return requestContentType.get();
        }
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        if (candidates.contains(defaultContentType)) {
            return defaultContentType;
        }
        return (ContentType)candidates.get(0);
    }

    private Optional<ContentType> defaultResponseContentType(MetaData metaData) {
        if (this.marshallersMap.isEmpty()) {
            return Optional.empty();
        }
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        if (this.marshallersMap.containsKey(defaultContentType)) {
            return Optional.ofNullable(defaultContentType);
        }
        return Optional.ofNullable(this.marshallersMap.keySet().iterator().next());
    }

    private static Optional<ContentType> responseContentType(MetaData metaData) {
        return metaData.getOptional(HttpMaidChainKeys.RESPONSE_HEADERS).flatMap(headers -> headers.getOptionalHeader("Content-Type").map(ContentType::fromString));
    }

    @Generated
    public String toString() {
        return "Marshallers(marshallersMap=" + this.marshallersMap + ", defaultContentTypeProvider=" + this.defaultContentTypeProvider + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Marshallers)) {
            return false;
        }
        Marshallers other = (Marshallers)o;
        Map<ContentType, Marshaller> this$marshallersMap = this.marshallersMap;
        Map<ContentType, Marshaller> other$marshallersMap = other.marshallersMap;
        if (this$marshallersMap == null ? other$marshallersMap != null : !((Object)this$marshallersMap).equals(other$marshallersMap)) {
            return false;
        }
        DefaultContentTypeProvider this$defaultContentTypeProvider = this.defaultContentTypeProvider;
        DefaultContentTypeProvider other$defaultContentTypeProvider = other.defaultContentTypeProvider;
        return !(this$defaultContentTypeProvider == null ? other$defaultContentTypeProvider != null : !this$defaultContentTypeProvider.equals(other$defaultContentTypeProvider));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ContentType, Marshaller> $marshallersMap = this.marshallersMap;
        result = result * 59 + ($marshallersMap == null ? 43 : ((Object)$marshallersMap).hashCode());
        DefaultContentTypeProvider $defaultContentTypeProvider = this.defaultContentTypeProvider;
        result = result * 59 + ($defaultContentTypeProvider == null ? 43 : $defaultContentTypeProvider.hashCode());
        return result;
    }

    @Generated
    private Marshallers(Map<ContentType, Marshaller> marshallersMap, DefaultContentTypeProvider defaultContentTypeProvider) {
        this.marshallersMap = marshallersMap;
        this.defaultContentTypeProvider = defaultContentTypeProvider;
    }
}

