/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializingSender<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerializingSender.class);
    private final WebsocketRegistry websocketRegistry;
    private final WebsocketSenders websocketSenders;
    private final ResolvedType messageType;
    private final Marshaller marshaller;
    private final Serializer serializer;
    private final MetaData metaData;

    public static <T> SerializingSender<T> serializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, ResolvedType messageType, Marshaller marshaller, Serializer serializer, MetaData metaData) {
        return new SerializingSender<T>(websocketRegistry, websocketSenders, messageType, marshaller, serializer, metaData);
    }

    public void sendToAll(T message) {
        this.sendTo(message, WebsocketCriteria.websocketCriteria());
    }

    public void sendTo(T message, WebsocketCriteria criteria) {
        Validators.validateNotNull(message, "message");
        Validators.validateNotNull(criteria, "criteria");
        List<WebsocketRegistryEntry> connections = this.websocketRegistry.connections(criteria);
        Map<WebsocketSenderId, List<WebsocketRegistryEntry>> bySenderId = connections.stream().collect(Collectors.groupingBy(WebsocketRegistryEntry::getSenderId));
        bySenderId.forEach((websocketSenderId, websocketRegistryEntries) -> {
            List connectionInformations = websocketRegistryEntries.stream().map(WebsocketRegistryEntry::connectionInformation).collect(Collectors.toList());
            WebsocketSender<ConnectionInformation> sender = this.websocketSenders.senderById((WebsocketSenderId)websocketSenderId);
            Object serialized = this.serializer.serialize(message, this.messageType);
            String marshalled = this.marshaller.marshall(serialized);
            sender.send(marshalled, connectionInformations, (connectionInformation, throwable) -> {
                log.info("exception when sending to websocket {} - removing websocket; request metadata: {}", new Object[]{connectionInformation, this.metaData, throwable});
                this.websocketRegistry.removeConnection((ConnectionInformation)connectionInformation);
            });
        });
    }

    @Generated
    public String toString() {
        return "SerializingSender(websocketRegistry=" + this.websocketRegistry + ", websocketSenders=" + this.websocketSenders + ", messageType=" + this.messageType + ", marshaller=" + this.marshaller + ", serializer=" + this.serializer + ", metaData=" + this.metaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializingSender)) {
            return false;
        }
        SerializingSender other = (SerializingSender)o;
        WebsocketRegistry this$websocketRegistry = this.websocketRegistry;
        WebsocketRegistry other$websocketRegistry = other.websocketRegistry;
        if (this$websocketRegistry == null ? other$websocketRegistry != null : !this$websocketRegistry.equals(other$websocketRegistry)) {
            return false;
        }
        WebsocketSenders this$websocketSenders = this.websocketSenders;
        WebsocketSenders other$websocketSenders = other.websocketSenders;
        if (this$websocketSenders == null ? other$websocketSenders != null : !((Object)this$websocketSenders).equals(other$websocketSenders)) {
            return false;
        }
        ResolvedType this$messageType = this.messageType;
        ResolvedType other$messageType = other.messageType;
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        Marshaller this$marshaller = this.marshaller;
        Marshaller other$marshaller = other.marshaller;
        if (this$marshaller == null ? other$marshaller != null : !this$marshaller.equals(other$marshaller)) {
            return false;
        }
        Serializer this$serializer = this.serializer;
        Serializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebsocketRegistry $websocketRegistry = this.websocketRegistry;
        result = result * 59 + ($websocketRegistry == null ? 43 : $websocketRegistry.hashCode());
        WebsocketSenders $websocketSenders = this.websocketSenders;
        result = result * 59 + ($websocketSenders == null ? 43 : ((Object)$websocketSenders).hashCode());
        ResolvedType $messageType = this.messageType;
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        Marshaller $marshaller = this.marshaller;
        result = result * 59 + ($marshaller == null ? 43 : $marshaller.hashCode());
        Serializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private SerializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, ResolvedType messageType, Marshaller marshaller, Serializer serializer, MetaData metaData) {
        this.websocketRegistry = websocketRegistry;
        this.websocketSenders = websocketSenders;
        this.messageType = messageType;
        this.marshaller = marshaller;
        this.serializer = serializer;
        this.metaData = metaData;
    }
}

