/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnect;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableWebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketConnectBuilder {
    private ConnectionInformation connectionInformation;
    private WebsocketSenderId websocketSenderId;
    private WebsocketRegistryEntry registryEntry;
    private final Map<MetaDataKey<?>, Object> additionalMetaData = new LinkedHashMap();

    public static RawWebsocketConnectBuilder rawWebsocketConnectBuilder() {
        return new RawWebsocketConnectBuilder();
    }

    public RawWebsocketConnectBuilder withNonSerializableConnectionInformation(NonSerializableConnectionInformation connectionInformation) {
        return this.withConnectionInformation(NonSerializableWebsocketSender.NON_SERIALIZABLE_WEBSOCKET_SENDER, connectionInformation);
    }

    public RawWebsocketConnectBuilder withConnectionInformation(WebsocketSenderId websocketSenderId, ConnectionInformation connectionInformation) {
        this.websocketSenderId = websocketSenderId;
        this.connectionInformation = connectionInformation;
        return this;
    }

    public RawWebsocketConnectBuilder withRegistryEntry(WebsocketRegistryEntry registryEntry) {
        this.registryEntry = registryEntry;
        return new RawWebsocketConnectBuilder();
    }

    public <T> RawWebsocketConnectBuilder withAdditionalMetaData(MetaDataKey<T> key, T value) {
        this.additionalMetaData.put(key, value);
        return this;
    }

    public RawWebsocketConnect build() {
        return RawWebsocketConnect.rawWebsocketConnect(this.connectionInformation, this.websocketSenderId, this.registryEntry, this.additionalMetaData);
    }

    @Generated
    public String toString() {
        return "RawWebsocketConnectBuilder(connectionInformation=" + this.connectionInformation + ", websocketSenderId=" + this.websocketSenderId + ", registryEntry=" + this.registryEntry + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketConnectBuilder)) {
            return false;
        }
        RawWebsocketConnectBuilder other = (RawWebsocketConnectBuilder)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$websocketSenderId = this.websocketSenderId;
        WebsocketSenderId other$websocketSenderId = other.websocketSenderId;
        if (this$websocketSenderId == null ? other$websocketSenderId != null : !((Object)this$websocketSenderId).equals(other$websocketSenderId)) {
            return false;
        }
        WebsocketRegistryEntry this$registryEntry = this.registryEntry;
        WebsocketRegistryEntry other$registryEntry = other.registryEntry;
        if (this$registryEntry == null ? other$registryEntry != null : !((Object)this$registryEntry).equals(other$registryEntry)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $websocketSenderId = this.websocketSenderId;
        result = result * 59 + ($websocketSenderId == null ? 43 : ((Object)$websocketSenderId).hashCode());
        WebsocketRegistryEntry $registryEntry = this.registryEntry;
        result = result * 59 + ($registryEntry == null ? 43 : ((Object)$registryEntry).hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketConnectBuilder() {
    }
}

