/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.HeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class CreateWebsocketRegistryEntryProcessor
implements Processor {
    private final HeaderFilter headerFilter;

    public static CreateWebsocketRegistryEntryProcessor createWebsocketRegistryEntryProcessor(HeaderFilter headerFilter) {
        NotNullValidator.validateNotNull((Object)headerFilter, (String)"headerFilter");
        return new CreateWebsocketRegistryEntryProcessor(headerFilter);
    }

    @Override
    public void apply(MetaData metaData) {
        ConnectionInformation connectionInformation = ConnectionInformation.dummyConnectionInformation();
        WebsocketSenderId senderId = metaData.get(WebsocketSenderId.WEBSOCKET_SENDER_ID);
        Headers headers = metaData.get(HttpMaidChainKeys.REQUEST_HEADERS);
        List<Header> filteredHeaders = this.headerFilter.filter(headers.asList());
        QueryParameters queryParameters = metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS);
        Map<String, Object> additionalData = metaData.get(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA);
        WebsocketRegistryEntry entry = WebsocketRegistryEntry.websocketRegistryEntry(connectionInformation, senderId, Headers.headers(filteredHeaders), queryParameters, additionalData);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY_ENTRY, entry);
    }

    @Generated
    private CreateWebsocketRegistryEntryProcessor(HeaderFilter headerFilter) {
        this.headerFilter = headerFilter;
    }
}

